package com.hero.util;

import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.ImageIcon;

import org.jdom.Element;

import com.hero.Hero;
import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.EnergyDefense;
import com.hero.objects.characteristics.Intelligence;
import com.hero.objects.characteristics.Leaping;
import com.hero.objects.characteristics.PhysicalDefense;
import com.hero.objects.characteristics.Presence;
import com.hero.objects.characteristics.Strength;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.perks.Perk;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.DamageResistance;
import com.hero.objects.powers.ForceField;
import com.hero.objects.powers.ForceWall;
import com.hero.objects.powers.MentalDefense;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.PowerDefense;
import com.hero.objects.skills.CombatLevels;
import com.hero.objects.skills.Skill;
import com.hero.objects.skills.SkillLevels;
import com.hero.objects.talents.LightningReflexesAll;
import com.hero.objects.talents.LightningReflexesSingle;
import com.hero.objects.talents.Talent;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class HTMLWriter {

	private static double parseMathString(String val) {

		ArrayList<String> parse = new ArrayList<String>();
		String holder = HTMLWriter.purifyMathString(val.trim());
		String number = null;
		String operand = null;
		while (holder.length() > 0) {
			int index1 = 0;
			int index2 = 0;
			INNER: for (int i = 0; i < holder.length(); i++) {
				if (Character.isDigit(holder.charAt(i))
						|| (holder.charAt(i) == '.')) {
					continue;
				} else {
					index2 = i;
					break INNER;
				}
			}
			if ((index2 == 0) && (parse.size() == 0)) {
				return -1;
			} else if (index2 == 0) {
				parse.add(holder);
				break;
			}
			number = holder.substring(index1, index2);
			parse.add(number);
			holder = holder.substring(index2, holder.length()).trim();
			if (holder.length() > 0) {
				operand = holder.substring(0, 1);
				holder = holder.substring(1, holder.length()).trim();
				if (holder.length() == 0) {
					return -1;
				}
				if (!operand.equals("+") && !operand.equals("-")
						&& !operand.equals("*") && !operand.equals("/")
						&& !operand.equals("^")) {
					return -1;
				}
				if (operand.equals("-")) {
					parse.add("+");
					parse.add("-1");
					parse.add("*");
				} else {
					parse.add(operand);
				}
			}
		}
		// I lied...before multiplication, exponents
		for (int i = 0; i < parse.size() - 1;) {
			if (!parse.get(i + 1).equals("^")) {
				i += 2;
				continue;
			}
			double num1 = Double.parseDouble(parse.get(i));
			double num2 = Double.parseDouble(parse.get(i + 2));
			double value = Math.pow(num1, num2);
			parse.remove(i + 2);
			parse.remove(i + 1);
			parse.remove(i);
			parse.add(i, "" + value);
		}
		// first off, multiplication
		for (int i = 0; i < parse.size() - 1;) {
			if (!parse.get(i + 1).equals("*")) {
				i += 2;
				continue;
			}
			double num1 = Double.parseDouble(parse.get(i).toString());
			double num2 = Double.parseDouble(parse.get(i + 2).toString());
			double value = num1 * num2;
			parse.remove(i + 2);
			parse.remove(i + 1);
			parse.remove(i);
			parse.add(i, "" + value);
		}
		// second off, division
		for (int i = 0; i < parse.size() - 1;) {
			if (!parse.get(i + 1).equals("/")) {
				i += 2;
				continue;
			}
			double num1 = Double.parseDouble(parse.get(i).toString());
			double num2 = Double.parseDouble(parse.get(i + 2).toString());
			double value = num1 / num2;
			parse.remove(i + 2);
			parse.remove(i + 1);
			parse.remove(i);
			parse.add(i, "" + value);
		}
		// finally, addition
		for (int i = 0; i < parse.size() - 1;) {
			if (!parse.get(i + 1).equals("+")) {
				i += 2;
				continue;
			}
			double num1 = Double.parseDouble(parse.get(i).toString());
			double num2 = Double.parseDouble(parse.get(i + 2).toString());
			double value = num1 + num2;
			parse.remove(i + 2);
			parse.remove(i + 1);
			parse.remove(i);
			parse.add(i, "" + value);
		}
		double ret = Double.parseDouble(parse.get(0));
		return ret;
	}

	private static String purifyMathString(String val) {
		StringBuffer holder = new StringBuffer();
		String allowedCharacters = "+-*/^().";
		for (int i = 0; i < val.length(); i++) {
			char c = val.charAt(i);
			if (Character.isDigit(c)) {
				holder.append(c);
			} else if (allowedCharacters.indexOf("" + c) >= 0) {
				holder.append(c);
			}
		}
		return holder.toString();
	}

	ArrayList<String> fileExtensions;

	String raw;

	Hero hero;

	boolean is6E = false;

	public HTMLWriter(File template) throws Exception {
		FileInputStream fis = new FileInputStream(template);
		byte[] data = new byte[fis.available()];
		fis.read(data);
		fis.close();
		raw = new String(data);
		getFileExtensions();
	}

	private String filterByType(String value, String type, GenericObject object) {
		String check = getLongValue("<!--IF_" + type + "-->", "<!--/IF_" + type
				+ "-->", value);
		while (check != null) {
			if (!object.getTypes().contains(type)) {
				value = swapLongValue("<!--IF_" + type + "-->", "<!--/IF_"
						+ type + "-->", "", value);
			} else {
				value = swapLongValue("<!--IF_" + type + "-->", "<!--/IF_"
						+ type + "-->", check, value);
			}
			check = getLongValue("<!--IF_" + type + "-->", "<!--/IF_" + type
					+ "-->", value);
		}
		return value;
	}

	/**
	 * Generates a Combat Record for the given Vector of Hero objects.
	 * 
	 * @see com.hero.Hero
	 * @param characters
	 * @return
	 * @throws Exception
	 */
	public String generateCombatRecord(ArrayList<Hero> characters)
			throws Exception {
		String ret = raw;
		Hero orig = HeroDesigner.getActiveHero();
		ret = swapAllLongValues("<!--TEMPLATE_NAME-->",
				"<!--/TEMPLATE_NAME-->", "", ret);
		ret = swapAllLongValues("<!--TEMPLATE_DESCRIPTION-->",
				"<!--/TEMPLATE_DESCRIPTION-->", "", ret);
		ret = swapValue("<!--APP_VERSION-->", HeroDesigner.version, ret);
		HeroDesigner.getAppFrame().setCursor(
				Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		raw = getLongValue("<!--CHARACTER-->", "<!--/CHARACTER-->", ret);
		String masValue = null;
		while ((raw != null) && (raw.trim().length() > 0)) {
			masValue = "";
			for (Hero h : characters) {
				HeroDesigner.getInstance().setActiveHero(h);
				HeroDesigner.getAppFrame().setCursor(
						Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				String val = generateOutput(h.getImageFileName(), h);
				masValue += val;
			}
			ret = swapLongValue("<!--CHARACTER-->", "<!--/CHARACTER-->",
					masValue, ret);
			raw = getLongValue("<!--CHARACTER-->", "<!--/CHARACTER-->", ret);
		}
		HeroDesigner.getInstance().setActiveHero(orig);
		HeroDesigner.getAppFrame().setCursor(
				Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		return ret;
	}

	/**
	 * Performs and export on the currently active character, using the
	 * specified imageName for the image value.
	 * 
	 * @param imageName
	 * @return
	 * @throws Exception
	 */
	public String generateOutput(String imageName) throws Exception {
		return generateOutput(imageName, HeroDesigner.getActiveHero());
	}

	/**
	 * Performs an export on the specified character, using the specified
	 * imageName for the image value.
	 * 
	 * @param imageName
	 * @param hero
	 * @return
	 * @throws Exception
	 */
	public String generateOutput(String imageName, Hero hero) throws Exception {
		this.hero = hero;
		is6E = HeroDesigner.getInstance().getActiveTemplate().is6E();
		String ret = raw;
		ret = swapAllLongValues("<!--TEMPLATE_NAME-->",
				"<!--/TEMPLATE_NAME-->", "", ret);
		ret = swapAllLongValues("<!--TEMPLATE_DESCRIPTION-->",
				"<!--/TEMPLATE_DESCRIPTION-->", "", ret);
		// take care of all the simple 1-1 stuff...
		SimpleDateFormat formatter = new SimpleDateFormat(
				"EEE, d MMM yyyy HH:mm:ss");
		SimpleDateFormat f2 = new SimpleDateFormat("yyyyMMddHHmmss");
		ret = swapValue("<!--APP_VERSION-->", HeroDesigner.version, ret);
		ret = swapValue("<!--TIMESTAMP-->", formatter.format(new Date()), ret);
	
		ret = swapValue("<!--EXPORT_ID-->", f2.format(new Date()), ret);
	
		ret = swapValue("<!--CHARACTER_SAVE_TIMESTAMP-->",
				hero.getSaveFile() != null ? formatter.format(
						new Date(hero.getSaveFile().lastModified())).toString()
						: "Never", ret);
		ret = swapValue("<!--CHARACTER_FILE-->",
				hero.getSaveFile() != null ? hero.getSaveFile().getName() : "",
				ret);
		ret = swapValue("<!--CHARACTER_NAME-->", hero.getCharacterName(), ret);
		ret = swapValue("<!--ALTERNATE_IDS-->", hero.getAlternateIdentities(),
				ret);
		ret = swapValue("<!--PLAYER_NAME-->", hero.getPlayerName(), ret);
		ret = swapValue("<!--CAMPAIGN_NAME-->", hero.getCampaignName(), ret);
		ret = swapValue("<!--GENRE-->", hero.getGenre(), ret);
		ret = swapValue("<!--GM-->", hero.getGm(), ret);
		ret = swapValue("<!--HAIR_COLOR-->", hero.getHairColor(), ret);
		ret = swapValue("<!--EYE_COLOR-->", hero.getEyeColor(), ret);
		Characteristic intelligence = hero.getCharacteristic(Constants.INT);
		Characteristic presence = hero.getCharacteristic(Constants.PRE);
		Characteristic speed = hero.getCharacteristic(Constants.SPD);
		if (intelligence != null) {
			ret = swapValue("<!--PER_ROLL-->", ((Intelligence) intelligence)
					.getPERRoll(), ret);
		} else {
			ret = swapValue("<!--PER_ROLL-->", "", ret);
		}
		if (presence != null) {
			ret = swapValue("<!--PRE_ATTACK-->", ((Presence) presence)
					.getPREAttack(), ret);
		} else {
			ret = swapValue("<!--PRE_ATTACK-->", "", ret);
		}
		if (speed != null) {
			int primary = (int) Rounder.roundDown(speed.getPrimaryValue());
			int secondary = (int) Rounder.roundDown(speed.getSecondaryValue());
			String phase1 = getLongValue("<!--IF_PRIMARY_PHASE_1-->",
					"<!--/IF_PRIMARY_PHASE_1-->", ret);
			String phase2 = getLongValue("<!--IF_PRIMARY_PHASE_2-->",
					"<!--/IF_PRIMARY_PHASE_2-->", ret);
			String phase3 = getLongValue("<!--IF_PRIMARY_PHASE_3-->",
					"<!--/IF_PRIMARY_PHASE_3-->", ret);
			String phase4 = getLongValue("<!--IF_PRIMARY_PHASE_4-->",
					"<!--/IF_PRIMARY_PHASE_4-->", ret);
			String phase5 = getLongValue("<!--IF_PRIMARY_PHASE_5-->",
					"<!--/IF_PRIMARY_PHASE_5-->", ret);
			String phase6 = getLongValue("<!--IF_PRIMARY_PHASE_6-->",
					"<!--/IF_PRIMARY_PHASE_6-->", ret);
			String phase7 = getLongValue("<!--IF_PRIMARY_PHASE_7-->",
					"<!--/IF_PRIMARY_PHASE_7-->", ret);
			String phase8 = getLongValue("<!--IF_PRIMARY_PHASE_8-->",
					"<!--/IF_PRIMARY_PHASE_8-->", ret);
			String phase9 = getLongValue("<!--IF_PRIMARY_PHASE_9-->",
					"<!--/IF_PRIMARY_PHASE_9-->", ret);
			String phase10 = getLongValue("<!--IF_PRIMARY_PHASE_10-->",
					"<!--/IF_PRIMARY_PHASE_10-->", ret);
			String phase11 = getLongValue("<!--IF_PRIMARY_PHASE_11-->",
					"<!--/IF_PRIMARY_PHASE_11-->", ret);
			String phase12 = getLongValue("<!--IF_PRIMARY_PHASE_12-->",
					"<!--/IF_PRIMARY_PHASE_12-->", ret);
			String secPhase1 = getLongValue("<!--IF_SECONDARY_PHASE_1-->",
					"<!--/IF_SECONDARY_PHASE_1-->", ret);
			String secPhase2 = getLongValue("<!--IF_SECONDARY_PHASE_2-->",
					"<!--/IF_SECONDARY_PHASE_2-->", ret);
			String secPhase3 = getLongValue("<!--IF_SECONDARY_PHASE_3-->",
					"<!--/IF_SECONDARY_PHASE_3-->", ret);
			String secPhase4 = getLongValue("<!--IF_SECONDARY_PHASE_4-->",
					"<!--/IF_SECONDARY_PHASE_4-->", ret);
			String secPhase5 = getLongValue("<!--IF_SECONDARY_PHASE_5-->",
					"<!--/IF_SECONDARY_PHASE_5-->", ret);
			String secPhase6 = getLongValue("<!--IF_SECONDARY_PHASE_6-->",
					"<!--/IF_SECONDARY_PHASE_6-->", ret);
			String secPhase7 = getLongValue("<!--IF_SECONDARY_PHASE_7-->",
					"<!--/IF_SECONDARY_PHASE_7-->", ret);
			String secPhase8 = getLongValue("<!--IF_SECONDARY_PHASE_8-->",
					"<!--/IF_SECONDARY_PHASE_8-->", ret);
			String secPhase9 = getLongValue("<!--IF_SECONDARY_PHASE_9-->",
					"<!--/IF_SECONDARY_PHASE_9-->", ret);
			String secPhase10 = getLongValue("<!--IF_SECONDARY_PHASE_10-->",
					"<!--/IF_SECONDARY_PHASE_10-->", ret);
			String secPhase11 = getLongValue("<!--IF_SECONDARY_PHASE_11-->",
					"<!--/IF_SECONDARY_PHASE_11-->", ret);
			String secPhase12 = getLongValue("<!--IF_SECONDARY_PHASE_12-->",
					"<!--/IF_SECONDARY_PHASE_12-->", ret);
			String notphase1 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_1-->",
					"<!--/IF_NOT_PRIMARY_PHASE_1-->", ret);
			String notphase2 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_2-->",
					"<!--/IF_NOT_PRIMARY_PHASE_2-->", ret);
			String notphase3 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_3-->",
					"<!--/IF_NOT_PRIMARY_PHASE_3-->", ret);
			String notphase4 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_4-->",
					"<!--/IF_NOT_PRIMARY_PHASE_4-->", ret);
			String notphase5 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_5-->",
					"<!--/IF_NOT_PRIMARY_PHASE_5-->", ret);
			String notphase6 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_6-->",
					"<!--/IF_NOT_PRIMARY_PHASE_6-->", ret);
			String notphase7 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_7-->",
					"<!--/IF_NOT_PRIMARY_PHASE_7-->", ret);
			String notphase8 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_8-->",
					"<!--/IF_NOT_PRIMARY_PHASE_8-->", ret);
			String notphase9 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_9-->",
					"<!--/IF_NOT_PRIMARY_PHASE_9-->", ret);
			String notphase10 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_10-->",
					"<!--/IF_NOT_PRIMARY_PHASE_10-->", ret);
			String notphase11 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_11-->",
					"<!--/IF_NOT_PRIMARY_PHASE_11-->", ret);
			String notphase12 = getLongValue("<!--IF_NOT_PRIMARY_PHASE_12-->",
					"<!--/IF_NOT_PRIMARY_PHASE_12-->", ret);
			String notsecPhase1 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_1-->",
					"<!--/IF_NOT_SECONDARY_PHASE_1-->", ret);
			String notsecPhase2 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_2-->",
					"<!--/IF_NOT_SECONDARY_PHASE_2-->", ret);
			String notsecPhase3 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_3-->",
					"<!--/IF_NOT_SECONDARY_PHASE_3-->", ret);
			String notsecPhase4 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_4-->",
					"<!--/IF_NOT_SECONDARY_PHASE_4-->", ret);
			String notsecPhase5 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_5-->",
					"<!--/IF_NOT_SECONDARY_PHASE_5-->", ret);
			String notsecPhase6 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_6-->",
					"<!--/IF_NOT_SECONDARY_PHASE_6-->", ret);
			String notsecPhase7 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_7-->",
					"<!--/IF_NOT_SECONDARY_PHASE_7-->", ret);
			String notsecPhase8 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_8-->",
					"<!--/IF_NOT_SECONDARY_PHASE_8-->", ret);
			String notsecPhase9 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_9-->",
					"<!--/IF_NOT_SECONDARY_PHASE_9-->", ret);
			String notsecPhase10 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_10-->",
					"<!--/IF_NOT_SECONDARY_PHASE_10-->", ret);
			String notsecPhase11 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_11-->",
					"<!--/IF_NOT_SECONDARY_PHASE_11-->", ret);
			String notsecPhase12 = getLongValue(
					"<!--IF_NOT_SECONDARY_PHASE_12-->",
					"<!--/IF_NOT_SECONDARY_PHASE_12-->", ret);
			if (secondary >= 12) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_1-->",
						"<!--/IF_SECONDARY_PHASE_1-->", secPhase1, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_1-->",
						"<!--/IF_NOT_SECONDARY_PHASE_1-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_1-->",
						"<!--/IF_SECONDARY_PHASE_1-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_1-->",
						"<!--/IF_NOT_SECONDARY_PHASE_1-->", notsecPhase1, ret);
			}
			if (secondary >= 6) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_2-->",
						"<!--/IF_SECONDARY_PHASE_2-->", secPhase2, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_2-->",
						"<!--/IF_NOT_SECONDARY_PHASE_2-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_2-->",
						"<!--/IF_SECONDARY_PHASE_2-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_2-->",
						"<!--/IF_NOT_SECONDARY_PHASE_2-->", notsecPhase2, ret);
			}
			if ((secondary == 4) || (secondary == 5) || (secondary >= 8)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_3-->",
						"<!--/IF_SECONDARY_PHASE_3-->", secPhase3, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_3-->",
						"<!--/IF_NOT_SECONDARY_PHASE_3-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_3-->",
						"<!--/IF_SECONDARY_PHASE_3-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_3-->",
						"<!--/IF_NOT_SECONDARY_PHASE_3-->", notsecPhase3, ret);
			}
			if ((secondary == 3) || (secondary == 6) || (secondary == 7)
					|| (secondary >= 9)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_4-->",
						"<!--/IF_SECONDARY_PHASE_4-->", secPhase4, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_4-->",
						"<!--/IF_NOT_SECONDARY_PHASE_4-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_4-->",
						"<!--/IF_SECONDARY_PHASE_4-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_4-->",
						"<!--/IF_NOT_SECONDARY_PHASE_4-->", notsecPhase4, ret);
			}
			if ((secondary == 5) || (secondary == 8) || (secondary >= 10)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_5-->",
						"<!--/IF_SECONDARY_PHASE_5-->", secPhase5, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_5-->",
						"<!--/IF_NOT_SECONDARY_PHASE_5-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_5-->",
						"<!--/IF_SECONDARY_PHASE_5-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_5-->",
						"<!--/IF_NOT_SECONDARY_PHASE_5-->", notsecPhase5, ret);
			}
			if ((secondary == 2) || (secondary == 4) || (secondary >= 6)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_6-->",
						"<!--/IF_SECONDARY_PHASE_6-->", secPhase6, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_6-->",
						"<!--/IF_NOT_SECONDARY_PHASE_6-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_6-->",
						"<!--/IF_SECONDARY_PHASE_6-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_6-->",
						"<!--/IF_NOT_SECONDARY_PHASE_6-->", notsecPhase6, ret);
			}
			if ((secondary == 1) || (secondary == 7) || (secondary == 9)
					|| (secondary >= 11)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_7-->",
						"<!--/IF_SECONDARY_PHASE_7-->", secPhase7, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_7-->",
						"<!--/IF_NOT_SECONDARY_PHASE_7-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_7-->",
						"<!--/IF_SECONDARY_PHASE_7-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_7-->",
						"<!--/IF_NOT_SECONDARY_PHASE_7-->", notsecPhase7, ret);
			}
			if ((secondary == 3) || (secondary == 5) || (secondary == 6)
					|| (secondary >= 8)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_8-->",
						"<!--/IF_SECONDARY_PHASE_8-->", secPhase8, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_8-->",
						"<!--/IF_NOT_SECONDARY_PHASE_8-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_8-->",
						"<!--/IF_SECONDARY_PHASE_8-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_8-->",
						"<!--/IF_NOT_SECONDARY_PHASE_8-->", notsecPhase8, ret);
			}
			if ((secondary == 4) || (secondary == 7) || (secondary == 8)
					|| (secondary >= 10)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_9-->",
						"<!--/IF_SECONDARY_PHASE_9-->", secPhase9, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_9-->",
						"<!--/IF_NOT_SECONDARY_PHASE_9-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_9-->",
						"<!--/IF_SECONDARY_PHASE_9-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_9-->",
						"<!--/IF_NOT_SECONDARY_PHASE_9-->", notsecPhase9, ret);
			}
			if ((secondary == 5) || (secondary == 6) || (secondary >= 9)) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_10-->",
						"<!--/IF_SECONDARY_PHASE_10-->", secPhase10, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_10-->",
						"<!--/IF_NOT_SECONDARY_PHASE_10-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_10-->",
						"<!--/IF_SECONDARY_PHASE_10-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_10-->",
						"<!--/IF_NOT_SECONDARY_PHASE_10-->", notsecPhase10, ret);
			}
			if (secondary >= 7) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_11-->",
						"<!--/IF_SECONDARY_PHASE_11-->", secPhase11, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_11-->",
						"<!--/IF_NOT_SECONDARY_PHASE_11-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_11-->",
						"<!--/IF_SECONDARY_PHASE_11-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_11-->",
						"<!--/IF_NOT_SECONDARY_PHASE_11-->", notsecPhase11, ret);
			}
			if (secondary >= 2) {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_12-->",
						"<!--/IF_SECONDARY_PHASE_12-->", secPhase12, ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_12-->",
						"<!--/IF_NOT_SECONDARY_PHASE_12-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SECONDARY_PHASE_12-->",
						"<!--/IF_SECONDARY_PHASE_12-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_12-->",
						"<!--/IF_NOT_SECONDARY_PHASE_12-->", notsecPhase12, ret);
			}
			if (primary >= 12) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_1-->",
						"<!--/IF_PRIMARY_PHASE_1-->", phase1, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_1-->",
						"<!--/IF_NOT_PRIMARY_PHASE_1-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_1-->",
						"<!--/IF_PRIMARY_PHASE_1-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_1-->",
						"<!--/IF_NOT_PRIMARY_PHASE_1-->", notphase1, ret);
			}
			if (primary >= 6) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_2-->",
						"<!--/IF_PRIMARY_PHASE_2-->", phase2, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_2-->",
						"<!--/IF_NOT_PRIMARY_PHASE_2-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_2-->",
						"<!--/IF_PRIMARY_PHASE_2-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_2-->",
						"<!--/IF_NOT_PRIMARY_PHASE_2-->", notphase2, ret);
			}
			if ((primary == 4) || (primary == 5) || (primary >= 8)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_3-->",
						"<!--/IF_PRIMARY_PHASE_3-->", phase3, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_3-->",
						"<!--/IF_NOT_PRIMARY_PHASE_3-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_3-->",
						"<!--/IF_PRIMARY_PHASE_3-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_3-->",
						"<!--/IF_NOT_PRIMARY_PHASE_3-->", notphase3, ret);
			}
			if ((primary == 3) || (primary == 6) || (primary == 7)
					|| (primary >= 9)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_4-->",
						"<!--/IF_PRIMARY_PHASE_4-->", phase4, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_4-->",
						"<!--/IF_NOT_PRIMARY_PHASE_4-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_4-->",
						"<!--/IF_PRIMARY_PHASE_4-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_4-->",
						"<!--/IF_NOT_PRIMARY_PHASE_4-->", notphase4, ret);
			}
			if ((primary == 5) || (primary == 8) || (primary >= 10)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_5-->",
						"<!--/IF_PRIMARY_PHASE_5-->", phase5, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_5-->",
						"<!--/IF_NOT_PRIMARY_PHASE_5-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_5-->",
						"<!--/IF_PRIMARY_PHASE_5-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_5-->",
						"<!--/IF_NOT_PRIMARY_PHASE_5-->", notphase5, ret);
			}
			if ((primary == 2) || (primary == 4) || (primary >= 6)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_6-->",
						"<!--/IF_PRIMARY_PHASE_6-->", phase6, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_6-->",
						"<!--/IF_NOT_PRIMARY_PHASE_6-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_6-->",
						"<!--/IF_PRIMARY_PHASE_6-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_6-->",
						"<!--/IF_NOT_PRIMARY_PHASE_6-->", notphase6, ret);
			}
			if ((primary == 1) || (primary == 7) || (primary == 9)
					|| (primary >= 11)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_7-->",
						"<!--/IF_PRIMARY_PHASE_7-->", phase7, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_7-->",
						"<!--/IF_NOT_PRIMARY_PHASE_7-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_7-->",
						"<!--/IF_PRIMARY_PHASE_7-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_7-->",
						"<!--/IF_NOT_PRIMARY_PHASE_7-->", notphase7, ret);
			}
			if ((primary == 3) || (primary == 5) || (primary == 6)
					|| (primary >= 8)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_8-->",
						"<!--/IF_PRIMARY_PHASE_8-->", phase8, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_8-->",
						"<!--/IF_NOT_PRIMARY_PHASE_8-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_8-->",
						"<!--/IF_PRIMARY_PHASE_8-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_8-->",
						"<!--/IF_NOT_PRIMARY_PHASE_8-->", notphase8, ret);
			}
			if ((primary == 4) || (primary == 7) || (primary == 8)
					|| (primary >= 10)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_9-->",
						"<!--/IF_PRIMARY_PHASE_9-->", phase9, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_9-->",
						"<!--/IF_NOT_PRIMARY_PHASE_9-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_9-->",
						"<!--/IF_PRIMARY_PHASE_9-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_9-->",
						"<!--/IF_NOT_PRIMARY_PHASE_9-->", notphase9, ret);
			}
			if ((primary == 5) || (primary == 6) || (primary >= 9)) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_10-->",
						"<!--/IF_PRIMARY_PHASE_10-->", phase10, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_10-->",
						"<!--/IF_NOT_PRIMARY_PHASE_10-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_10-->",
						"<!--/IF_PRIMARY_PHASE_10-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_10-->",
						"<!--/IF_NOT_PRIMARY_PHASE_10-->", notphase10, ret);
			}
			if (primary >= 7) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_11-->",
						"<!--/IF_PRIMARY_PHASE_11-->", phase11, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_11-->",
						"<!--/IF_NOT_PRIMARY_PHASE_11-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_11-->",
						"<!--/IF_PRIMARY_PHASE_11-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_11-->",
						"<!--/IF_NOT_PRIMARY_PHASE_11-->", notphase11, ret);
			}
			if (primary >= 2) {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_12-->",
						"<!--/IF_PRIMARY_PHASE_12-->", phase12, ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_12-->",
						"<!--/IF_NOT_PRIMARY_PHASE_12-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_PRIMARY_PHASE_12-->",
						"<!--/IF_PRIMARY_PHASE_12-->", "", ret);
				ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_12-->",
						"<!--/IF_NOT_PRIMARY_PHASE_12-->", notphase12, ret);
			}
		} else {
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_1-->",
					"<!--/IF_PRIMARY_PHASE_1-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_1-->",
					"<!--/IF_SECONDARY_PHASE_1-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_2-->",
					"<!--/IF_PRIMARY_PHASE_2-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_2-->",
					"<!--/IF_SECONDARY_PHASE_2-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_3-->",
					"<!--/IF_PRIMARY_PHASE_3-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_3-->",
					"<!--/IF_SECONDARY_PHASE_3-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_4-->",
					"<!--/IF_PRIMARY_PHASE_4-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_4-->",
					"<!--/IF_SECONDARY_PHASE_4-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_5-->",
					"<!--/IF_PRIMARY_PHASE_5-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_5-->",
					"<!--/IF_SECONDARY_PHASE_5-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_6-->",
					"<!--/IF_PRIMARY_PHASE_6-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_6-->",
					"<!--/IF_SECONDARY_PHASE_6-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_7-->",
					"<!--/IF_PRIMARY_PHASE_7-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_7-->",
					"<!--/IF_SECONDARY_PHASE_7-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_8-->",
					"<!--/IF_PRIMARY_PHASE_8-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_8-->",
					"<!--/IF_SECONDARY_PHASE_8-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_9-->",
					"<!--/IF_PRIMARY_PHASE_9-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_9-->",
					"<!--/IF_SECONDARY_PHASE_9-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_10-->",
					"<!--/IF_PRIMARY_PHASE_10-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_10-->",
					"<!--/IF_SECONDARY_PHASE_10-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_11-->",
					"<!--/IF_PRIMARY_PHASE_11-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_11-->",
					"<!--/IF_SECONDARY_PHASE_11-->", "", ret);
			ret = swapLongValue("<!--IF_PRIMARY_PHASE_12-->",
					"<!--/IF_PRIMARY_PHASE_12-->", "", ret);
			ret = swapLongValue("<!--IF_SECONDARY_PHASE_12-->",
					"<!--/IF_SECONDARY_PHASE_12-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_1-->",
					"<!--/IF_NOT_PRIMARY_PHASE_1-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_1-->",
					"<!--/IF_NOT_SECONDARY_PHASE_1-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_2-->",
					"<!--/IF_NOT_PRIMARY_PHASE_2-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_2-->",
					"<!--/IF_NOT_SECONDARY_PHASE_2-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_3-->",
					"<!--/IF_NOT_PRIMARY_PHASE_3-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_3-->",
					"<!--/IF_NOT_SECONDARY_PHASE_3-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_4-->",
					"<!--/IF_NOT_PRIMARY_PHASE_4-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_4-->",
					"<!--/IF_NOT_SECONDARY_PHASE_4-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_5-->",
					"<!--/IF_NOT_PRIMARY_PHASE_5-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_5-->",
					"<!--/IF_NOT_SECONDARY_PHASE_5-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_6-->",
					"<!--/IF_NOT_PRIMARY_PHASE_6-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_6-->",
					"<!--/IF_NOT_SECONDARY_PHASE_6-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_7-->",
					"<!--/IF_NOT_PRIMARY_PHASE_7-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_7-->",
					"<!--/IF_NOT_SECONDARY_PHASE_7-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_8-->",
					"<!--/IF_NOT_PRIMARY_PHASE_8-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_8-->",
					"<!--/IF_NOT_SECONDARY_PHASE_8-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_9-->",
					"<!--/IF_NOT_PRIMARY_PHASE_9-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_9-->",
					"<!--/IF_NOT_SECONDARY_PHASE_9-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_10-->",
					"<!--/IF_NOT_PRIMARY_PHASE_10-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_10-->",
					"<!--/IF_NOT_SECONDARY_PHASE_10-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_11-->",
					"<!--/IF_NOT_PRIMARY_PHASE_11-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_11-->",
					"<!--/IF_NOT_SECONDARY_PHASE_11-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_PRIMARY_PHASE_12-->",
					"<!--/IF_NOT_PRIMARY_PHASE_12-->", "", ret);
			ret = swapLongValue("<!--IF_NOT_SECONDARY_PHASE_12-->",
					"<!--/IF_NOT_SECONDARY_PHASE_12-->", "", ret);
		}
		String appearanceCheck = getLongValue("<!--IF_APPEARANCE-->",
				"<!--/IF_APPEARANCE-->", ret);
		if (appearanceCheck != null) {
			if (hero.getAppearance().trim().length() > 0) {
				ret = swapAllLongValues("<!--IF_APPEARANCE-->",
						"<!--/IF_APPEARANCE-->", appearanceCheck, ret);
			} else {
				ret = swapAllLongValues("<!--IF_APPEARANCE-->",
						"<!--/IF_APPEARANCE-->", "", ret);
			}
		}
		String notesCheck = getLongValue("<!--IF_NOTES-->", "<!--/IF_NOTES-->",
				ret);
		while (notesCheck != null) {
			if (((hero.getNotes1().trim().length() > 0) && hero.getRules()
					.useNotes1())
					|| ((hero.getNotes2().trim().length() > 0) && hero
							.getRules().useNotes2())
					|| ((hero.getNotes3().trim().length() > 0) && hero
							.getRules().useNotes3())
					|| ((hero.getNotes4().trim().length() > 0) && hero
							.getRules().useNotes4())
					|| ((hero.getNotes5().trim().length() > 0) && hero
							.getRules().useNotes5())) {
				ret = swapLongValue("<!--IF_NOTES-->", "<!--/IF_NOTES-->",
						notesCheck, ret);
				notesCheck = getLongValue("<!--IF_NOTES-->",
						"<!--/IF_NOTES-->", ret);
			} else {
				ret = swapLongValue("<!--IF_NOTES-->", "<!--/IF_NOTES-->", "",
						ret);
				notesCheck = getLongValue("<!--IF_NOTES-->",
						"<!--/IF_NOTES-->", ret);
			}
		}
		String notes1Check = getLongValue("<!--IF_NOTES1-->",
				"<!--/IF_NOTES1-->", ret);
		if (notes1Check != null) {
			if ((hero.getNotes1().trim().length() > 0)
					&& hero.getRules().useNotes1()) {
				ret = swapAllLongValues("<!--IF_NOTES1-->",
						"<!--/IF_NOTES1-->", notes1Check, ret);
			} else {
				ret = swapAllLongValues("<!--IF_NOTES1-->",
						"<!--/IF_NOTES1-->", "", ret);
			}
		}
		String notes2Check = getLongValue("<!--IF_NOTES2-->",
				"<!--/IF_NOTES2-->", ret);
		if (notes2Check != null) {
			if ((hero.getNotes2().trim().length() > 0)
					&& hero.getRules().useNotes2()) {
				ret = swapAllLongValues("<!--IF_NOTES2-->",
						"<!--/IF_NOTES2-->", notes2Check, ret);
			} else {
				ret = swapAllLongValues("<!--IF_NOTES2-->",
						"<!--/IF_NOTES2-->", "", ret);
			}
		}
		String notes3Check = getLongValue("<!--IF_NOTES3-->",
				"<!--/IF_NOTES3-->", ret);
		if (notes3Check != null) {
			if ((hero.getNotes3().trim().length() > 0)
					&& hero.getRules().useNotes3()) {
				ret = swapAllLongValues("<!--IF_NOTES3-->",
						"<!--/IF_NOTES3-->", notes3Check, ret);
			} else {
				ret = swapAllLongValues("<!--IF_NOTES3-->",
						"<!--/IF_NOTES3-->", "", ret);
			}
		}
		String notes4Check = getLongValue("<!--IF_NOTES4-->",
				"<!--/IF_NOTES4-->", ret);
		if (notes4Check != null) {
			if ((hero.getNotes4().trim().length() > 0)
					&& hero.getRules().useNotes4()) {
				ret = swapAllLongValues("<!--IF_NOTES4-->",
						"<!--/IF_NOTES4-->", notes4Check, ret);
			} else {
				ret = swapAllLongValues("<!--IF_NOTES4-->",
						"<!--/IF_NOTES4-->", "", ret);
			}
		}
		String notes5Check = getLongValue("<!--IF_NOTES5-->",
				"<!--/IF_NOTES5-->", ret);
		if (notes5Check != null) {
			if ((hero.getNotes5().trim().length() > 0)
					&& hero.getRules().useNotes5()) {
				ret = swapAllLongValues("<!--IF_NOTES5-->",
						"<!--/IF_NOTES5-->", notes5Check, ret);
			} else {
				ret = swapAllLongValues("<!--IF_NOTES5-->",
						"<!--/IF_NOTES5-->", "", ret);
			}
		}
		String backgroundCheck = getLongValue("<!--IF_BACKGROUND-->",
				"<!--/IF_BACKGROUND-->", ret);
		if (backgroundCheck != null) {
			if (hero.getBackground().trim().length() > 0) {
				ret = swapAllLongValues("<!--IF_BACKGROUND-->",
						"<!--/IF_BACKGROUND-->", backgroundCheck, ret);
			} else {
				ret = swapAllLongValues("<!--IF_BACKGROUND-->",
						"<!--/IF_BACKGROUND-->", "", ret);
			}
		}
		String personalityCheck = getLongValue("<!--IF_PERSONALITY-->",
				"<!--/IF_PERSONALITY-->", ret);
		if (personalityCheck != null) {
			if (hero.getPersonality().trim().length() > 0) {
				ret = swapAllLongValues("<!--IF_PERSONALITY-->",
						"<!--/IF_PERSONALITY-->", personalityCheck, ret);
			} else {
				ret = swapAllLongValues("<!--IF_PERSONALITY-->",
						"<!--/IF_PERSONALITY-->", "", ret);
			}
		}
		String quoteCheck = getLongValue("<!--IF_QUOTE-->", "<!--/IF_QUOTE-->",
				ret);
		if (quoteCheck != null) {
			if (hero.getQuote().trim().length() > 0) {
				ret = swapAllLongValues("<!--IF_QUOTE-->", "<!--/IF_QUOTE-->",
						quoteCheck, ret);
			} else {
				ret = swapAllLongValues("<!--IF_QUOTE-->", "<!--/IF_QUOTE-->",
						"", ret);
			}
		}
		String tacticsCheck = getLongValue("<!--IF_TACTICS-->",
				"<!--/IF_TACTICS-->", ret);
		if (tacticsCheck != null) {
			if (hero.getTactics().trim().length() > 0) {
				ret = swapAllLongValues("<!--IF_TACTICS-->",
						"<!--/IF_TACTICS-->", tacticsCheck, ret);
			} else {
				ret = swapAllLongValues("<!--IF_TACTICS-->",
						"<!--/IF_TACTICS-->", "", ret);
			}
		}
		String campaignUseCheck = getLongValue("<!--IF_CAMPAIGN_USE-->",
				"<!--/IF_CAMPAIGN_USE-->", ret);
		if (campaignUseCheck != null) {
			if (hero.getCampaignUse().trim().length() > 0) {
				ret = swapAllLongValues("<!--IF_CAMPAIGN_USE-->",
						"<!--/IF_CAMPAIGN_USE-->", campaignUseCheck, ret);
			} else {
				ret = swapAllLongValues("<!--IF_CAMPAIGN_USE-->",
						"<!--/IF_CAMPAIGN_USE-->", "", ret);
			}
		}
		String appContainer = getLongValue("<!--APPEARANCE-->",
				"<!--/APPEARANCE-->", ret);
		boolean gotOne = false;
		if (appContainer != null) {
			appContainer = appContainer.trim();
		}
		while ((appContainer != null) && (appContainer.indexOf("\n") < 0)) {
			String appearance = hero.getAppearance();
			while (appearance.indexOf("\n") > 0) {
				String part1 = appearance
						.substring(0, appearance.indexOf("\n"));
				String part2 = appearance.substring(
						appearance.indexOf("\n") + 1, appearance.length());
				appearance = part1 + appContainer + part2;
			}
			ret = swapLongValue("<!--APPEARANCE-->", "<!--/APPEARANCE-->",
					appearance, ret);
			appContainer = getLongValue("<!--APPEARANCE-->",
					"<!--/APPEARANCE-->", ret);
			if (appContainer != null) {
				appContainer = appContainer.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--APPEARANCE-->", "<!--/APPEARANCE-->", hero
				.getAppearance(), ret);
		if (!gotOne) {
			ret = swapValue("<!--APPEARANCE-->", hero.getAppearance(), ret);
		}
		String notes1Container = getLongValue("<!--NOTES1-->",
				"<!--/NOTES1-->", ret);
		gotOne = false;
		if (notes1Container != null) {
			notes1Container = notes1Container.trim();
		}
		while ((notes1Container != null) && (notes1Container.indexOf("\n") < 0)) {
			String notes = hero.getNotes1();
			while (notes.indexOf("\n") > 0) {
				String part1 = notes.substring(0, notes.indexOf("\n"));
				String part2 = notes.substring(notes.indexOf("\n") + 1, notes
						.length());
				notes = part1 + notes1Container + part2;
			}
			ret = swapLongValue("<!--NOTES1-->", "<!--/NOTES1-->", notes, ret);
			notes1Container = getLongValue("<!--NOTES1-->", "<!--/NOTES1-->",
					ret);
			if (notes1Container != null) {
				notes1Container = notes1Container.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--NOTES1-->", "<!--/NOTES1-->", hero
				.getNotes1(), ret);
		ret = swapValue("<!--NOTES1_LABEL-->",
				hero.getRules().getNotes1Label(), ret);
		String notes2Container = getLongValue("<!--NOTES2-->",
				"<!--/NOTES2-->", ret);
		gotOne = false;
		if (notes2Container != null) {
			notes2Container = notes2Container.trim();
		}
		while ((notes2Container != null) && (notes2Container.indexOf("\n") < 0)) {
			String notes = hero.getNotes2();
			while (notes.indexOf("\n") > 0) {
				String part1 = notes.substring(0, notes.indexOf("\n"));
				String part2 = notes.substring(notes.indexOf("\n") + 1, notes
						.length());
				notes = part1 + notes2Container + part2;
			}
			ret = swapLongValue("<!--NOTES2-->", "<!--/NOTES2-->", notes, ret);
			notes2Container = getLongValue("<!--NOTES2-->", "<!--/NOTES2-->",
					ret);
			if (notes2Container != null) {
				notes2Container = notes2Container.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--NOTES2-->", "<!--/NOTES2-->", hero
				.getNotes2(), ret);
		ret = swapValue("<!--NOTES2_LABEL-->",
				hero.getRules().getNotes2Label(), ret);
		String notes3Container = getLongValue("<!--NOTES3-->",
				"<!--/NOTES3-->", ret);
		gotOne = false;
		if (notes3Container != null) {
			notes3Container = notes3Container.trim();
		}
		while ((notes3Container != null) && (notes3Container.indexOf("\n") < 0)) {
			String notes = hero.getNotes3();
			while (notes.indexOf("\n") > 0) {
				String part1 = notes.substring(0, notes.indexOf("\n"));
				String part2 = notes.substring(notes.indexOf("\n") + 1, notes
						.length());
				notes = part1 + notes3Container + part2;
			}
			ret = swapLongValue("<!--NOTES3-->", "<!--/NOTES3-->", notes, ret);
			notes3Container = getLongValue("<!--NOTES3-->", "<!--/NOTES3-->",
					ret);
			if (notes3Container != null) {
				notes3Container = notes3Container.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--NOTES3-->", "<!--/NOTES3-->", hero
				.getNotes3(), ret);
		ret = swapValue("<!--NOTES3_LABEL-->",
				hero.getRules().getNotes3Label(), ret);
		String notes4Container = getLongValue("<!--NOTES4-->",
				"<!--/NOTES4-->", ret);
		gotOne = false;
		if (notes4Container != null) {
			notes4Container = notes4Container.trim();
		}
		while ((notes4Container != null) && (notes4Container.indexOf("\n") < 0)) {
			String notes = hero.getNotes4();
			while (notes.indexOf("\n") > 0) {
				String part1 = notes.substring(0, notes.indexOf("\n"));
				String part2 = notes.substring(notes.indexOf("\n") + 1, notes
						.length());
				notes = part1 + notes4Container + part2;
			}
			ret = swapLongValue("<!--NOTES4-->", "<!--/NOTES4-->", notes, ret);
			notes4Container = getLongValue("<!--NOTES4-->", "<!--/NOTES4-->",
					ret);
			if (notes4Container != null) {
				notes4Container = notes4Container.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--NOTES4-->", "<!--/NOTES4-->", hero
				.getNotes4(), ret);
		ret = swapValue("<!--NOTES4_LABEL-->",
				hero.getRules().getNotes4Label(), ret);
		String notes5Container = getLongValue("<!--NOTES5-->",
				"<!--/NOTES5-->", ret);
		gotOne = false;
		if (notes5Container != null) {
			notes5Container = notes5Container.trim();
		}
		while ((notes5Container != null) && (notes5Container.indexOf("\n") < 0)) {
			String notes = hero.getNotes5();
			while (notes.indexOf("\n") > 0) {
				String part1 = notes.substring(0, notes.indexOf("\n"));
				String part2 = notes.substring(notes.indexOf("\n") + 1, notes
						.length());
				notes = part1 + notes5Container + part2;
			}
			ret = swapLongValue("<!--NOTES5-->", "<!--/NOTES5-->", notes, ret);
			notes5Container = getLongValue("<!--NOTES5-->", "<!--/NOTES5-->",
					ret);
			if (notes5Container != null) {
				notes5Container = notes5Container.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--NOTES5-->", "<!--/NOTES5-->", hero
				.getNotes5(), ret);
		ret = swapValue("<!--NOTES5_LABEL-->",
				hero.getRules().getNotes5Label(), ret);
		String backContainer = getLongValue("<!--BACKGROUND-->",
				"<!--/BACKGROUND-->", ret);
		gotOne = false;
		if (backContainer != null) {
			backContainer = backContainer.trim();
		}
		while ((backContainer != null) && (backContainer.indexOf("\n") < 0)) {
			String background = hero.getBackground();
			while (background.indexOf("\n") > 0) {
				String part1 = background
						.substring(0, background.indexOf("\n"));
				String part2 = background.substring(
						background.indexOf("\n") + 1, background.length());
				background = part1 + backContainer + part2;
			}
			ret = swapLongValue("<!--BACKGROUND-->", "<!--/BACKGROUND-->",
					background, ret);
			backContainer = getLongValue("<!--BACKGROUND-->",
					"<!--/BACKGROUND-->", ret);
			if (backContainer != null) {
				backContainer = backContainer.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--BACKGROUND-->", "<!--/BACKGROUND-->", hero
				.getBackground(), ret);
		if (!gotOne) {
			ret = swapValue("<!--BACKGROUND-->", hero.getBackground(), ret);
		}
		String personalityContainer = getLongValue("<!--PERSONALITY-->",
				"<!--/PERSONALITY-->", ret);
		gotOne = false;
		if (personalityContainer != null) {
			personalityContainer = personalityContainer.trim();
		}
		while ((personalityContainer != null)
				&& (personalityContainer.indexOf("\n") < 0)) {
			String personality = hero.getPersonality();
			while (personality.indexOf("\n") > 0) {
				String part1 = personality.substring(0, personality
						.indexOf("\n"));
				String part2 = personality.substring(
						personality.indexOf("\n") + 1, personality.length());
				personality = part1 + personalityContainer + part2;
			}
			ret = swapLongValue("<!--PERSONALITY-->", "<!--/PERSONALITY-->",
					personality, ret);
			personalityContainer = getLongValue("<!--PERSONALITY-->",
					"<!--/PERSONALITY-->", ret);
			if (personalityContainer != null) {
				personalityContainer = personalityContainer.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--PERSONALITY-->", "<!--/PERSONALITY-->",
				hero.getPersonality(), ret);
		if (!gotOne) {
			ret = swapValue("<!--PERSONALITY-->", hero.getPersonality(), ret);
		}
		String quoteContainer = getLongValue("<!--QUOTE-->", "<!--/QUOTE-->",
				ret);
		gotOne = false;
		if (quoteContainer != null) {
			quoteContainer = quoteContainer.trim();
		}
		while ((quoteContainer != null) && (quoteContainer.indexOf("\n") < 0)) {
			String quote = hero.getQuote();
			while (quote.indexOf("\n") > 0) {
				String part1 = quote.substring(0, quote.indexOf("\n"));
				String part2 = quote.substring(quote.indexOf("\n") + 1, quote
						.length());
				quote = part1 + quoteContainer + part2;
			}
			ret = swapLongValue("<!--QUOTE-->", "<!--/QUOTE-->", quote, ret);
			quoteContainer = getLongValue("<!--QUOTE-->", "<!--/QUOTE-->", ret);
			if (quoteContainer != null) {
				quoteContainer = quoteContainer.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--QUOTE-->", "<!--/QUOTE-->", hero
				.getQuote(), ret);
		if (!gotOne) {
			ret = swapValue("<!--QUOTE-->", hero.getQuote(), ret);
		}
		String tacticsContainer = getLongValue("<!--TACTICS-->",
				"<!--/TACTICS-->", ret);
		gotOne = false;
		if (tacticsContainer != null) {
			tacticsContainer = tacticsContainer.trim();
		}
		while ((tacticsContainer != null)
				&& (tacticsContainer.indexOf("\n") < 0)) {
			String tactics = hero.getTactics();
			while (tactics.indexOf("\n") > 0) {
				String part1 = tactics.substring(0, tactics.indexOf("\n"));
				String part2 = tactics.substring(tactics.indexOf("\n") + 1,
						tactics.length());
				tactics = part1 + tacticsContainer + part2;
			}
			ret = swapLongValue("<!--TACTICS-->", "<!--/TACTICS-->", tactics,
					ret);
			tacticsContainer = getLongValue("<!--TACTICS-->",
					"<!--/TACTICS-->", ret);
			if (tacticsContainer != null) {
				tacticsContainer = tacticsContainer.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--TACTICS-->", "<!--/TACTICS-->", hero
				.getTactics(), ret);
		if (!gotOne) {
			ret = swapValue("<!--TACTICS-->", hero.getTactics(), ret);
		}
		String cuContainer = getLongValue("<!--CAMPAIGN_USE-->",
				"<!--/CAMPAIGN_USE-->", ret);
		gotOne = false;
		if (cuContainer != null) {
			cuContainer = cuContainer.trim();
		}
		while ((cuContainer != null) && (cuContainer.indexOf("\n") < 0)) {
			String cu = hero.getCampaignUse();
			while (cu.indexOf("\n") > 0) {
				String part1 = cu.substring(0, cu.indexOf("\n"));
				String part2 = cu.substring(cu.indexOf("\n") + 1, cu.length());
				cu = part1 + cuContainer + part2;
			}
			ret = swapLongValue("<!--CAMPAIGN_USE-->", "<!--/CAMPAIGN_USE-->",
					cu, ret);
			cuContainer = getLongValue("<!--CAMPAIGN_USE-->",
					"<!--/CAMPAIGN_USE-->", ret);
			if (cuContainer != null) {
				cuContainer = cuContainer.trim();
			}
			gotOne = true;
		}
		ret = swapAllLongValues("<!--CAMPAIGN_USE-->", "<!--/CAMPAIGN_USE-->",
				hero.getCampaignUse(), ret);
		if (!gotOne) {
			ret = swapValue("<!--CAMPAIGN_USE-->", hero.getCampaignUse(), ret);
		}
		int in = (int) Rounder.roundHalfUp(hero.getHeight());
		int lbs = (int) Rounder.roundHalfUp(hero.getWeight());
		double cm = hero.getHeight();
		double kg = hero.getWeight();
		if (HeroDesigner.getInstance().getPrefs().isMetric()) {
			in = (int) Rounder.roundHalfUp(hero.getHeight() / 2.54);
			lbs = (int) Rounder.roundHalfUp(hero.getWeight() * 2.204622476);
		} else {
			cm = hero.getHeight() * 2.54;
			kg = hero.getWeight() / 2.204622476;
		}
		int feet = in / 12;
		int inches = in % 12;
		BigDecimal hght = new BigDecimal(cm / 100d);
		hght = hght.setScale(2, hght.ROUND_HALF_UP);
		BigDecimal wght = new BigDecimal(kg);
		wght = wght.setScale(2, wght.ROUND_HALF_UP);
		if (HeroDesigner.getInstance().getPrefs().isMetric()) {
			ret = swapValue("<!--HEIGHT-->", hght.toString() + " m", ret);
			ret = swapValue("<!--WEIGHT-->", wght.toString() + " kg", ret);
		} else {
			ret = swapValue("<!--HEIGHT-->", feet + "' " + inches + "\"", ret);
			ret = swapValue("<!--WEIGHT-->", lbs + " lbs", ret);
		}
		ret = swapValue("<!--HEIGHT_METRIC-->", hght.toString() + " m", ret);
		ret = swapValue("<!--WEIGHT_METRIC-->", wght.toString() + " kg", ret);
		ret = swapValue("<!--HEIGHT_ENGLISH-->", feet + "' " + inches + "\"",
				ret);
		ret = swapValue("<!--WEIGHT_ENGLISH-->", lbs + " lbs", ret);
		// CHARACTERISTICS
		String chStr = "STR";
		String tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
				+ "-->", ret);
		Characteristic ch = hero.getCharacteristic(Constants.STR);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				String roll = ((Strength) ch).getHthDamageString();
				tmp = swapValue("<!--" + chStr + "_DICE-->", roll, tmp);
				String lift = "";
				double liftVal1 = 25d;
				double liftVal2 = 25d;
				double pow1 = ch.getPrimaryValue() / 5d;
				double pow2 = ch.getSecondaryValue() / 5d;
				if (pow1 > 0) {
					liftVal1 = Math.pow(2, pow1) * liftVal1;
				} else {
					liftVal1 = liftVal1 / Math.pow(2, Math.abs(pow1));
				}
				if (pow2 > 0) {
					liftVal2 = Math.pow(2, pow2) * liftVal2;
				} else {
					liftVal2 = liftVal2 / Math.pow(2, Math.abs(pow2));
				}
				String units1 = "kg";
				if (liftVal1 >= 1000000) {
					liftVal1 = liftVal1 / 1000000;
					units1 = "ktons";
				} else if (liftVal1 >= 10000) {
					liftVal1 = liftVal1 / 1000;
					units1 = "tons";
				}
				String units2 = "kg";
				if (liftVal2 >= 1000000) {
					liftVal2 = liftVal2 / 1000000;
					units2 = "ktons";
				} else if (liftVal2 >= 10000) {
					liftVal2 = liftVal2 / 1000;
					units2 = "tons";
				}
				BigDecimal bd1 = new BigDecimal(liftVal1);
				bd1 = bd1.setScale(1, bd1.ROUND_HALF_UP);
				lift = bd1.toString() + units1;
				if (liftVal1 != liftVal2) {
					BigDecimal bd2 = new BigDecimal(liftVal2);
					bd2 = bd2.setScale(1, bd2.ROUND_HALF_UP);
					lift += "/" + bd2.toString() + units2;
				}
				tmp = swapValue("<!--" + chStr + "_LIFT-->", lift, tmp);
				int primary = ((Strength) ch).getPrimaryEND();
				int secondary = ((Strength) ch).getSecondaryEND();
				String end = primary != secondary ? primary + "/" + secondary
						: "" + primary;
				String endValue = getLongValue("<!--IF_END-->",
						"<!--/IF_END-->", tmp);
				if (endValue != null) {
					if ((end.trim().length() == 0) || end.equals("0")) {
						tmp = swapLongValue("<!--IF_END-->", "<!--/IF_END-->",
								"", tmp);
					} else {
						tmp = swapLongValue("<!--IF_END-->", "<!--/IF_END-->",
								endValue, tmp);
					}
				}
				tmp = swapValue("<!--" + chStr + "_END-->", end, tmp);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "DEX";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.DEX);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				long initiative2 = Rounder.roundHalfUp(ch.getSecondaryValue());
				long initiative = Rounder.roundHalfUp(ch.getPrimaryValue());
				for (GenericObject obj : hero.getTalents()) {
					if (obj.getXMLID().equals("LIGHTNING_REFLEXES_ALL")) {
						LightningReflexesAll lfa = (LightningReflexesAll) obj;
						initiative += lfa.getLevels();
						initiative2 += lfa.getLevels();
					} else if (obj instanceof List) {
						List l = (List) obj;
						for (GenericObject obj2 : l.getObjects()) {
							if (obj2.getXMLID()
									.equals("LIGHTNING_REFLEXES_ALL")) {
								LightningReflexesAll lfa = (LightningReflexesAll) obj2;
								initiative += lfa.getLevels();
								initiative2 += lfa.getLevels();
							}
						}
					}
				}
				for (GenericObject obj : hero.getPowers()) {
					if (obj.getXMLID().equals("LIGHTNING_REFLEXES_ALL")) {
						LightningReflexesAll lfa = (LightningReflexesAll) obj;
						initiative += lfa.getLevels();
						initiative2 += lfa.getLevels();
					} else if (obj instanceof List) {
						List l = (List) obj;
						for (GenericObject obj2 : l.getObjects()) {
							if (obj2.getXMLID()
									.equals("LIGHTNING_REFLEXES_ALL")) {
								LightningReflexesAll lfa = (LightningReflexesAll) obj2;
								initiative += lfa.getLevels();
								initiative2 += lfa.getLevels();
							}
						}
					}
				}
				for (GenericObject obj : hero.getEquipment()) {
					if (obj.getXMLID().equals("LIGHTNING_REFLEXES_ALL")) {
						LightningReflexesAll lfa = (LightningReflexesAll) obj;
						initiative += lfa.getLevels();
						initiative2 += lfa.getLevels();
					} else if (obj instanceof List) {
						List l = (List) obj;
						for (GenericObject obj2 : l.getObjects()) {
							if (obj2.getXMLID()
									.equals("LIGHTNING_REFLEXES_ALL")) {
								LightningReflexesAll lfa = (LightningReflexesAll) obj2;
								initiative += lfa.getLevels();
								initiative2 += lfa.getLevels();
							}
						}
					}
				}
				String init = "" + initiative;
				if (initiative != initiative2) {
					init += " / " + initiative2;
				}
				tmp = swapValue("<!--INITIATIVE-->", init, tmp);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CON";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CON);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "BODY";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.BODY);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "INT";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.INT);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "EGO";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.EGO);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "PRE";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.PRE);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				String roll = "";
				double whole = (ch.getPrimaryValue() - (int) ch
						.getPrimaryValue() % 5) / 5;
				int frac = (int) ch.getPrimaryValue() % 5;
				if ((frac > 2) && (whole > 0)) {
					roll = Rounder.roundHalfUp(whole) + " 1/2";
				} else if (frac > 2) {
					roll = "1/2";
				} else {
					roll = "" + Rounder.roundHalfUp(whole);
				}
				roll = roll + "d6";
				String roll2 = "";
				double whole2 = (ch.getSecondaryValue() - Rounder.roundDown(ch
						.getSecondaryValue()) % 5) / 5;
				int frac2 = (int) Rounder.roundDown(ch.getSecondaryValue()) % 5;
				if ((frac2 > 2) && (whole2 > 0)) {
					roll2 = Rounder.roundHalfUp(whole2) + " 1/2";
				} else if (frac2 > 2) {
					roll2 = "1/2";
				} else {
					roll2 = "" + Rounder.roundHalfUp(whole2);
				}
				roll2 = roll2 + "d6";
				if (!roll.equals(roll2)) {
					roll += "/" + roll2;
				}
				tmp = swapValue("<!--" + chStr + "_DICE-->", roll, tmp);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "COM";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.COM);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "PD";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.PD);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else if (tmp != null) {
			PhysicalDefense ed = (PhysicalDefense) ch;
			int res1 = ed.getResistantTotal(true);
			int res2 = ed.getResistantTotal(false);
			int non1 = ed.getNonresistantTotal(true);
			int non2 = ed.getNonresistantTotal(false);
			String res = "" + res1;
			if (res1 != res2) {
				res += "/" + res2;
			}
			String nonRes = "" + non1;
			if (non1 != non2) {
				nonRes += "/" + non2;
			}
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				tmp = swapValue("<!--" + chStr + "_NONRESISTANT_TOTAL-->",
						nonRes, tmp);
				tmp = swapValue("<!--" + chStr + "_RESISTANT_TOTAL-->", res,
						tmp);
				tmp = swapValue("<!--" + chStr + "_RESISTANT_PRIMARY-->", ""
						+ res1, tmp);
				tmp = swapValue("<!--" + chStr + "_RESISTANT_SECONDARY-->", ""
						+ res2, tmp);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "ED";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.ED);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else if (tmp != null) {
			EnergyDefense ed = (EnergyDefense) ch;
			int res1 = ed.getResistantTotal(true);
			int res2 = ed.getResistantTotal(false);
			int non1 = ed.getNonresistantTotal(true);
			int non2 = ed.getNonresistantTotal(false);
			String res = "" + res1;
			if (res1 != res2) {
				res += "/" + res2;
			}
			String nonRes = "" + non1;
			if (non1 != non2) {
				nonRes += "/" + non2;
			}
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				tmp = swapValue("<!--" + chStr + "_NONRESISTANT_TOTAL-->",
						nonRes, tmp);
				tmp = swapValue("<!--" + chStr + "_RESISTANT_TOTAL-->", res,
						tmp);
				tmp = swapValue("<!--" + chStr + "_RESISTANT_PRIMARY-->", ""
						+ res1, tmp);
				tmp = swapValue("<!--" + chStr + "_RESISTANT_SECONDARY-->", ""
						+ res2, tmp);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "SPD";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.SPD);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = swapValue("<!--" + chStr + "_VAL-->", ""
						+ Rounder.roundHalfUp(ch.getCharacteristicValue()), tmp);
				BigDecimal bd = new BigDecimal(ch.getBaseValue());
				bd = bd.setScale(1, bd.ROUND_HALF_UP);
				tmp = swapValue("<!--" + chStr + "_BASE-->", bd.toString(), tmp);
				tmp = swapValue("<!--BASE-->", bd.toString(), tmp);
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "REC";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.REC);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "END";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.END);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "STUN";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.STUN);
		if (GenericObject.findObjectByID(hero.getPowers(), "AUTOMATON") != null) {
			GenericObject auto = GenericObject.findObjectByID(hero.getPowers(),
					"AUTOMATON");
			if (auto.getSelectedOption().getXMLID().toUpperCase().startsWith(
					"NOSTUN")) {
				ch = null;
			}
		}
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "DEF";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.DEF);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "SIZE";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.SIZE);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				String dcvEffect = "" + ch.getDcvEffect(true);
				if (ch.getDcvEffect(true) != ch.getDcvEffect(false)) {
					dcvEffect += "/" + ch.getDcvEffect(false);
				}
				tmp = swapValue("<!--" + chStr + "_DCV_EFFECT-->", dcvEffect,
						tmp);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "RUNNING";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.RUNNING);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "SWIMMING";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.SWIMMING);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "LEAPING";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.LEAPING);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				Leaping lp = (Leaping) ch;
				double primaryForward = lp.getPrimaryForward();
				double primaryUpward = lp.getPrimaryUpward();
				double secondaryForward = lp.getSecondaryForward();
				double secondaryUpward = lp.getSecondaryUpward();
				String pFor = "";
				if (primaryForward - Rounder.roundDown(primaryForward) > .75) {
					pFor = Rounder.roundUp(primaryForward)
							+ (is6E ? "m" : "\"");
				} else if (primaryForward - Rounder.roundDown(primaryForward) > .25) {
					pFor = Rounder.roundDown(primaryForward) + " 1/2"
							+ (is6E ? "m" : "\"");
				} else {
					pFor = Rounder.roundDown(primaryForward)
							+ (is6E ? "m" : "\"");
				}
				String pUp = "";
				if (primaryUpward - Rounder.roundDown(primaryUpward) > .75) {
					pUp = Rounder.roundUp(primaryUpward) + (is6E ? "m" : "\"");
				} else if (primaryUpward - Rounder.roundDown(primaryUpward) > .25) {
					pUp = Rounder.roundDown(primaryUpward) + " 1/2"
							+ (is6E ? "m" : "\"");
				} else {
					pUp = Rounder.roundDown(primaryUpward)
							+ (is6E ? "m" : "\"");
				}
				String primary = pUp;
				if (primaryForward != primaryUpward) {
					primary = pFor + "/" + pUp;
				}
				String secFor = "";
				if (secondaryForward - Rounder.roundDown(secondaryForward) > .75) {
					secFor = Rounder.roundUp(secondaryForward)
							+ (is6E ? "m" : "\"");
				} else if (secondaryForward
						- Rounder.roundDown(secondaryForward) > .25) {
					secFor = Rounder.roundDown(secondaryForward) + " 1/2"
							+ (is6E ? "m" : "\"");
				} else {
					secFor = Rounder.roundDown(secondaryForward)
							+ (is6E ? "m" : "\"");
				}
				String secUp = "";
				if (secondaryUpward - Rounder.roundDown(secondaryUpward) > .75) {
					secUp = Rounder.roundUp(secondaryUpward)
							+ (is6E ? "m" : "\"");
				} else if (secondaryUpward - Rounder.roundDown(secondaryUpward) > .25) {
					secUp = Rounder.roundDown(secondaryUpward) + " 1/2"
							+ (is6E ? "m" : "\"");
				} else {
					secUp = Rounder.roundDown(secondaryUpward)
							+ (is6E ? "m" : "\"");
				}
				String secondary = secUp;
				if (secondaryForward != secondaryUpward) {
					secondary = secFor + "/" + secUp;
				}
				String up = "" + pUp;
				if (primaryUpward != secondaryUpward) {
					up = pUp + "/" + secUp;
				}
				String forward = "" + pFor;
				if (primaryForward != secondaryForward) {
					forward = pFor + "/" + secFor;
				}
				double base = lp.getBaseValue();
				int baseForward = (int) Rounder.roundHalfUp(base);
				int baseUpward = (int) Rounder.roundHalfUp(base / 2);
				tmp = swapValue("<!--" + chStr + "_PRIMARY-->", primary, tmp);
				tmp = swapValue("<!--" + chStr + "_SECONDARY-->", secondary,
						tmp);
				tmp = swapValue("<!--" + chStr + "_PRIMARY_NUMBER-->", Rounder
						.roundHalfUp(primaryForward)
						+ "", tmp);
				tmp = swapValue("<!--" + chStr + "_SECONDARY_NUMBER-->",
						Rounder.roundHalfUp(secondaryForward) + "", tmp);
				tmp = swapValue("<!--" + chStr + "_HORIZONTAL_BASE-->", ""
						+ baseForward + (is6E ? "m" : "\""), tmp);
				tmp = swapValue("<!--" + chStr + "_HORIZONTAL_TOTAL-->", ""
						+ forward, tmp);
				tmp = swapValue("<!--" + chStr + "_VERTICAL_BASE-->", ""
						+ baseUpward + (is6E ? "m" : "\""), tmp);
				tmp = swapValue("<!--" + chStr + "_VERTICAL_TOTAL-->", "" + up,
						tmp);
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "OCV_CHAR";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.OCV);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "DCV_CHAR";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.DCV);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "OMCV";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.OMCV);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "DMCV";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.DMCV);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM1";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM1);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM2";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM2);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM3";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM3);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM4";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM4);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM5";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM5);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM6";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM6);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM7";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM7);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM8";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM8);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM9";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM9);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		chStr = "CUSTOM10";
		tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr + "-->", ret);
		ch = hero.getCharacteristic(Constants.CUSTOM10);
		if ((tmp != null) && (ch == null)) {
			ret = swapAllLongValues("<!--" + chStr + "-->", "<!--/" + chStr
					+ "-->", "", ret);
		} else {
			while (tmp != null) {
				String orig = "<!--" + chStr + "-->" + tmp + "<!--/" + chStr
						+ "-->";
				tmp = getGeneralCharString(tmp, chStr, ch);
				ret = swapValue(orig, tmp, ret);
				tmp = getLongValue("<!--" + chStr + "-->", "<!--/" + chStr
						+ "-->", ret);
			}
		}
		// get other movement totals...
		ret = swapMovementString(ret, "RUNNING");
		ret = swapMovementString(ret, "SWIMMING");
		ret = swapMovementString(ret, "LEAPING");
		ret = swapMovementString(ret, "FLIGHT");
		ret = swapMovementString(ret, "GLIDING");
		ret = swapMovementString(ret, "SWINGING");
		ret = swapMovementString(ret, "TELEPORTATION");
		ret = swapMovementString(ret, "TUNNELING");
		tmp = getLongValue("<!--IMAGE-->", "<!--/IMAGE-->", ret);
		String img = imageName;
		if (((tmp != null) && (img == null)) || (img.trim().length() == 0)) {
			ret = swapAllLongValues("<!--IMAGE-->", "<!--/IMAGE-->", "", ret);
			String noImg = getLongValue("<!--IF_NO_IMAGE-->",
					"<!--/IF_NO_IMAGE-->", ret);
			if (noImg == null) {
				noImg = "";
			}
			ret = swapAllLongValues("<!--IF_NO_IMAGE-->",
					"<!--/IF_NO_IMAGE-->", noImg, ret);
		} else if (tmp != null) {
			String newVal = swapValue("<!--IMAGE_RELATIVE_URL-->", img, tmp);
			ret = swapValue("<!--IMAGE-->" + tmp + "<!--/IMAGE-->", newVal, ret);
			ret = swapAllLongValues("<!--IF_NO_IMAGE-->",
					"<!--/IF_NO_IMAGE-->", "", ret);
		}
		tmp = getLongValue("<!--IF_IMAGE-->", "<!--/IF_IMAGE-->", ret);
		img = imageName;
		if (((tmp != null) && (img == null)) || (img.trim().length() == 0)) {
			ret = swapAllLongValues("<!--IF_IMAGE-->", "<!--/IF_IMAGE-->", "",
					ret);
			String noImg = getLongValue("<!--IF_NO_IMAGE-->",
					"<!--/IF_NO_IMAGE-->", ret);
			if (noImg == null) {
				noImg = "";
			}
			ret = swapAllLongValues("<!--IF_NO_IMAGE-->",
					"<!--/IF_NO_IMAGE-->", noImg, ret);
		} else if (tmp != null) {
			String newVal = swapValue("<!--IMAGE_RELATIVE_URL-->", img, tmp);
			ret = swapValue("<!--IF_IMAGE-->" + tmp + "<!--/IF_IMAGE-->",
					newVal, ret);
			ret = swapAllLongValues("<!--IF_NO_IMAGE-->",
					"<!--/IF_NO_IMAGE-->", "", ret);
		}
		int experience = hero.getExperience();
		int base = hero.getBasePoints();
		int disad = hero.getDisadPoints();
		int totalSpent = (int) Rounder.roundUp(hero.getSpentTotal());
		int disadsUsed = hero.getDisadsUsed();
		int expSpent = totalSpent - (base + disadsUsed);
		if (is6E) {
			expSpent += disadsUsed;
		}
		if (expSpent < 0) {
			expSpent = 0;
		}
		int unspent = experience - expSpent;
		if (unspent < 0) {
			unspent = 0;
		}
		double skillTotal = 0;
		double perkTotal = 0;
		double talentTotal = 0;
		double maneuverTotal = 0;
		double powerTotal = 0;
		double activeTotal = 0;
		for (GenericObject o : hero.getSkills()) {
			skillTotal += o.getRealCost();
			activeTotal += o.getActiveCost();
		}
		for (GenericObject o : hero.getPerks()) {
			perkTotal += o.getRealCost();
			activeTotal += o.getActiveCost();
		}
		for (GenericObject o : hero.getTalents()) {
			talentTotal += o.getRealCost();
			activeTotal += o.getActiveCost();
		}
		for (GenericObject o : hero.getManeuvers()) {
			maneuverTotal += o.getRealCost();
			activeTotal += o.getActiveCost();
		}
		for (GenericObject o : hero.getPowers()) {
			powerTotal += o.getRealCost();
			activeTotal += o.getActiveCost();
		}
		for (GenericObject o : hero.getCharacteristics()) {
			activeTotal += o.getActiveCost();
		}
		ret = swapValue("<!--EARNED_EXP-->", "" + experience, ret);
		String ifSpent = getLongValue("<!--IF_SPENT_EXP-->",
				"<!--/IF_SPENT_EXP-->", ret);
		while (ifSpent != null) {
			if (expSpent == 0) {
				ret = swapLongValue("<!--IF_SPENT_EXP-->",
						"<!--/IF_SPENT_EXP-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_SPENT_EXP-->",
						"<!--/IF_SPENT_EXP-->", ifSpent, ret);
			}
			ifSpent = getLongValue("<!--IF_SPENT_EXP-->",
					"<!--/IF_SPENT_EXP-->", ret);
		}
		String ifUnSpent = getLongValue("<!--IF_UNSPENT_EXP-->",
				"<!--/IF_UNSPENT_EXP-->", ret);
		while (ifUnSpent != null) {
			if (unspent == 0) {
				ret = swapLongValue("<!--IF_UNSPENT_EXP-->",
						"<!--/IF_UNSPENT_EXP-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_UNSPENT_EXP-->",
						"<!--/IF_UNSPENT_EXP-->", ifUnSpent, ret);
			}
			ifUnSpent = getLongValue("<!--IF_UNSPENT_EXP-->",
					"<!--/IF_UNSPENT_EXP-->", ret);
		}
		ret = swapValue("<!--SPENT_EXP-->", "" + expSpent, ret);
		ret = swapValue("<!--UNSPENT_EXP-->", "" + unspent, ret);
		ret = swapValue("<!--BASE_POINTS-->", "" + base, ret);
		ret = swapValue("<!--DISAD_POINTS-->", "" + disadsUsed, ret);
		ret = swapValue("<!--DISAD_POINTS_ALLOWED-->", "" + disad, ret);
		ret = swapValue("<!--TOTAL_POINTS-->", "" + totalSpent, ret);
		ret = swapValue("<!--TOTAL_UNSPENT-->", ""
				+ (is6E?(base+experience-totalSpent):(base + disad + experience - totalSpent)), ret);
		ret = swapValue("<!--CHARACTERISTIC_POINTS-->", ""
				+ Rounder.roundUp(hero.getCharacteristicsTotal()), ret);
		ret = swapValue("<!--SKILL_POINTS-->",
				"" + Rounder.roundUp(skillTotal), ret);
		ret = swapValue("<!--PERK_POINTS-->", "" + Rounder.roundUp(perkTotal),
				ret);
		ret = swapValue("<!--TALENT_POINTS-->", ""
				+ Rounder.roundUp(talentTotal), ret);
		ret = swapValue("<!--SKILL_PERK_TALENT_POINTS-->", ""
				+ Rounder.roundUp(skillTotal + perkTotal + talentTotal), ret);
		ret = swapValue("<!--SKILL_PERK_TALENT_MARTIAL_ART_POINTS-->", ""
				+ Rounder.roundUp(skillTotal + perkTotal + talentTotal
						+ maneuverTotal), ret);
		ret = swapValue("<!--SKILL_PERK_TALENT_MARTIAL_ART_POWER_POINTS-->", ""
				+ Rounder.roundUp(totalSpent - hero.getCharacteristicsTotal()),
				ret);
		ret = swapValue("<!--MARTIAL_ART_POINTS-->", ""
				+ Rounder.roundUp(maneuverTotal), ret);
		ret = swapValue("<!--POWER_POINTS-->",
				"" + Rounder.roundUp(powerTotal), ret);
		ret = swapValue("<!--POWER_MARTIAL_ART_POINTS-->", ""
				+ Rounder.roundUp(powerTotal + maneuverTotal), ret);
		ret = swapValue("<!--TOTAL_ACTIVE_COST-->", ""
				+ Rounder.roundUp(activeTotal), ret);
		int md = 0;
		boolean addEgo = false;
		MentalDefense mdef = new MentalDefense(new Element("MENTALDEFENSE"));
		md = mdef.getMdLevels();
		if (!is6E) {
			OUTER: for (int i = 0; (i < hero.getPowers().size()) && !addEgo; i++) {
				if ((hero.getPowers().get(i) instanceof Power)
						&& !(hero.getPowers().get(i) instanceof DamageResistance)
						&& !(hero.getPowers().get(i) instanceof ForceWall)) {
					Power def = (Power) hero.getPowers().get(i);
					if (def instanceof MentalDefense) {
						addEgo = true;
					} else if (def instanceof CompoundPower) {
						CompoundPower cp = (CompoundPower) def;
						for (int j = 0; j < cp.getPowers().size(); j++) {
							if (cp.getPowers().get(j) instanceof MentalDefense) {
								addEgo = true;
								break OUTER;
							}
						}
					}
				}
			}
			OUTER: for (int i = 0; (i < hero.getEquipment().size()) && !addEgo; i++) {
				if ((hero.getEquipment().get(i) instanceof Power)
						&& !(hero.getEquipment().get(i) instanceof DamageResistance)
						&& !(hero.getEquipment().get(i) instanceof ForceWall)) {
					Power def = (Power) hero.getEquipment().get(i);
					if (def instanceof MentalDefense) {
						addEgo = true;
					} else if (def instanceof CompoundPower) {
						CompoundPower cp = (CompoundPower) def;
						for (int j = 0; j < cp.getPowers().size(); j++) {
							if (cp.getPowers().get(j) instanceof MentalDefense) {
								addEgo = true;
								break OUTER;
							}
						}
					}
				}
			}
		}
		for (int i = 0; i < hero.getCharacteristics().size(); i++) {
			Characteristic mdCh = (Characteristic) hero.getCharacteristics()
					.get(i);
			md += mdCh.getMdLevels();
		}
		Characteristic ego = hero.getCharacteristic(Constants.EGO);
		if ((ego != null) && (md > 0) && addEgo) {
			int num = md
					+ (int) Rounder.roundHalfUp(ego.getPrimaryValue() / 5d);
			int secNum = md
					+ (int) Rounder.roundHalfUp(ego.getSecondaryValue() / 5d);
			String swap = num + "";
			if (num != secNum) {
				swap = num + "/" + secNum;
			}
			ret = swapValue("<!--MENTAL_DEFENSE_TOTAL-->", swap, ret);
		} else {
			ret = swapValue("<!--MENTAL_DEFENSE_TOTAL-->", "" + md, ret);
		}
		if (md > 0) {
			String m = getLongValue("<!--IF_MENTAL_DEFENSE-->",
					"<!--/IF_MENTAL_DEFENSE-->", ret);
			while ((m != null) && (m.length() > 0)) {
				ret = swapLongValue("<!--IF_MENTAL_DEFENSE-->",
						"<!--/IF_MENTAL_DEFENSE-->", m, ret);
				m = getLongValue("<!--IF_MENTAL_DEFENSE-->",
						"<!--/IF_MENTAL_DEFENSE-->", ret);
			}
			ret = swapAllLongValues("<!--IF_NO_MENTAL_DEFENSE-->",
					"<!--/IF_NO_MENTAL_DEFENSE-->", "", ret);
		} else {
			ret = swapAllLongValues("<!--IF_MENTAL_DEFENSE-->",
					"<!--/IF_MENTAL_DEFENSE-->", "", ret);
			String m = getLongValue("<!--IF_NO_MENTAL_DEFENSE-->",
					"<!--/IF_NO_MENTAL_DEFENSE-->", ret);
			while ((m != null) && (m.length() > 0)) {
				ret = swapLongValue("<!--IF_NO_MENTAL_DEFENSE-->",
						"<!--/IF_NO_MENTAL_DEFENSE-->", m, ret);
				m = getLongValue("<!--IF_NO_MENTAL_DEFENSE-->",
						"<!--/IF_NO_MENTAL_DEFENSE-->", ret);
			}
		}
		int pd = 0;
		for (int i = 0; i < hero.getPowers().size(); i++) {
			if (hero.getPowers().get(i) instanceof PowerDefense) {
				PowerDefense def = (PowerDefense) hero.getPowers().get(i);
				pd += def.getLevels();
			} else if (hero.getPowers().get(i) instanceof ForceField) {
				ForceField ff = (ForceField) hero.getPowers().get(i);
				pd += ff.getPowdLevels();
			} else if (hero.getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) hero.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof PowerDefense) {
						PowerDefense def = (PowerDefense) cp.getPowers().get(j);
						pd += def.getLevels();
					} else if (cp.getPowers().get(j) instanceof ForceField) {
						ForceField ff = (ForceField) cp.getPowers().get(j);
						pd += ff.getPowdLevels();
					}
				}
			}
		}
		for (int i = 0; i < hero.getEquipment().size(); i++) {
			if (hero.getEquipment().get(i) instanceof PowerDefense) {
				PowerDefense def = (PowerDefense) hero.getEquipment().get(i);
				pd += def.getLevels();
			} else if (hero.getEquipment().get(i) instanceof ForceField) {
				ForceField ff = (ForceField) hero.getEquipment().get(i);
				pd += ff.getPowdLevels();
			} else if (hero.getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) hero.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof PowerDefense) {
						PowerDefense def = (PowerDefense) cp.getPowers().get(j);
						pd += def.getLevels();
					} else if (cp.getPowers().get(j) instanceof ForceField) {
						ForceField ff = (ForceField) cp.getPowers().get(j);
						pd += ff.getPowdLevels();
					}
				}
			}
		}
		ret = swapValue("<!--POWER_DEFENSE_TOTAL-->", "" + pd, ret);
	
		Characteristic OCV = hero.getCharacteristic(Constants.OCV);
		if (OCV != null) {
			// BEGIN 6E CV HANDLING
			int dcv1 = 0;
			int dcv2 = 0;
			int ocv1 = (int) OCV.getPrimaryValue();
			int ocv2 = (int) OCV.getSecondaryValue();
			int omcv1 = 0;
			int omcv2 = 0;
			int dmcv1 = 0;
			int dmcv2 = 0;
	
			String ocv = "" + ocv1;
			if (ocv1 != ocv2) {
				ocv += "/" + ocv2;
			}
	
			Characteristic DCV = hero.getCharacteristic(Constants.DCV);
			if (DCV != null) {
				dcv1 = (int) DCV.getPrimaryValue();
				dcv2 = (int) DCV.getSecondaryValue();
			}
			String dcv = "" + dcv1;
			if (dcv1 != dcv2) {
				dcv += "/" + dcv2;
			}
	
			Characteristic OMCV = hero.getCharacteristic(Constants.OMCV);
			if (OMCV != null) {
				omcv1 = (int) OMCV.getPrimaryValue();
				omcv2 = (int) OMCV.getSecondaryValue();
			}
			String omcv = "" + omcv1;
			if (omcv1 != omcv2) {
				omcv += "/" + omcv2;
			}
	
			Characteristic DMCV = hero.getCharacteristic(Constants.DMCV);
			if (DMCV != null) {
				dmcv1 = (int) DMCV.getPrimaryValue();
				dmcv2 = (int) DMCV.getSecondaryValue();
			}
			String dmcv = "" + dmcv1;
			if (dmcv1 != dmcv2) {
				dmcv += "/" + dmcv2;
			}
	
			ret = swapValue("<!--DCV-->", dcv, ret);
			ret = swapValue("<!--PRIMARY_DCV-->", "" + dcv1, ret);
			ret = swapValue("<!--SECONDARY_DCV-->", "" + dcv2, ret);
			ret = swapValue("<!--OCV-->", ocv, ret);
			ret = swapValue("<!--PRIMARY_OCV-->", "" + ocv1, ret);
			ret = swapValue("<!--SECONDARY_OCV-->", "" + ocv2, ret);
			ret = swapValue("<!--DMCV-->", dmcv, ret);
			ret = swapValue("<!--PRIMARY_DMCV-->", "" + dmcv1, ret);
			ret = swapValue("<!--SECONDARY_DMCV-->", "" + dmcv2, ret);
			ret = swapValue("<!--OMCV-->", omcv, ret);
			ret = swapValue("<!--PRIMARY_OMCV-->", "" + omcv1, ret);
			ret = swapValue("<!--SECONDARY_OMCV-->", "" + omcv2, ret);
			ret = swapValue("<!--ECV-->", omcv + " - " + dmcv, ret);
			ret = swapValue("<!--PRIMARY_ECV-->", omcv1 + " - " + dmcv1, ret);
			ret = swapValue("<!--SECONDARY_ECV-->", omcv2 + " - " + dmcv2, ret);
			// END 6E CV HANDLING
		} else {
			// BEGIN 5ER CV HANDLING
			int ocvBase = 0;
			int dcvBase = 0;
			int ecvBase = 0;
			double ocv1 = 0;
			double ocv2 = 0;
			double dcv1 = 0;
			double dcv2 = 0;
			double ecv1 = 0;
			double ecv2 = 0;
			String dcvTotal = "0";
			String ocvTotal = "0";
			String ecvTotal = "0";
			Characteristic dex = hero.getCharacteristic(Constants.DEX);
			if (dex != null) {
				ocvBase += Rounder.roundHalfUp(dex.getBaseValue()
						* dex.getOcvIncrease() / dex.getOcvIncreaseLevels());
				dcvBase += Rounder.roundHalfUp(dex.getBaseValue()
						* dex.getDcvIncrease() / dex.getDcvIncreaseLevels());
				for (int i = 0; i < hero.getCharacteristics().size(); i++) {
					ch = (Characteristic) hero.getCharacteristics().get(i);
					if (ch.getOcvIncreaseLevels() != 0) {
						int mul = ch.getOcvIncrease() < 0 ? -1 : 1;
						double ocv = 0;
						ocv = Math.abs(ch.getOcvIncrease())
								* ch.getPrimaryValue()
								/ ch.getOcvIncreaseLevels();
						ocv = ocv * mul;
						ocv1 += ocv;
					}
					if (ch.getDcvIncreaseLevels() != 0) {
						dcv1 += ch.getDcvEffect(true);
					}
				}
				for (int i = 0; i < hero.getCharacteristics().size(); i++) {
					ch = (Characteristic) hero.getCharacteristics().get(i);
					if (ch.getOcvIncreaseLevels() != 0) {
						int mul = ch.getOcvIncrease() < 0 ? -1 : 1;
						double ocv = 0;
						ocv = Math.abs(ch.getOcvIncrease())
								* ch.getSecondaryValue()
								/ ch.getOcvIncreaseLevels();
						ocv = ocv * mul;
						ocv2 += ocv;
					}
					if (ch.getDcvIncreaseLevels() != 0) {
						dcv2 += ch.getDcvEffect(false);
					}
				}
				if (ocv1 == ocv2) {
					ocvTotal = "" + Rounder.roundHalfUp(ocv1);
				} else {
					ocvTotal = Rounder.roundHalfUp(ocv1) + "/"
							+ Rounder.roundHalfUp(ocv2);
				}
				if (dcv1 == dcv2) {
					dcvTotal = "" + Rounder.roundHalfUp(dcv1);
				} else {
					dcvTotal = Rounder.roundHalfUp(dcv1) + "/"
							+ Rounder.roundHalfUp(dcv2);
				}
			}
			if (ego != null) {
				ecvBase += Rounder.roundHalfUp(ego.getBaseValue()
						* ego.getEcvIncrease() / ego.getEcvIncreaseLevels());
				for (int i = 0; i < hero.getCharacteristics().size(); i++) {
					ch = (Characteristic) hero.getCharacteristics().get(i);
					if (ch.getEcvIncreaseLevels() != 0) {
						int mul = ch.getEcvIncrease() < 0 ? -1 : 1;
						double ecv = 0;
						ecv = Math.abs(ch.getEcvIncrease())
								* ch.getPrimaryValue()
								/ ch.getEcvIncreaseLevels();
						ecv = ecv * mul;
						ecv1 += ecv;
					}
				}
				for (int i = 0; i < hero.getCharacteristics().size(); i++) {
					ch = (Characteristic) hero.getCharacteristics().get(i);
					if (ch.getEcvIncreaseLevels() != 0) {
						int mul = ch.getEcvIncrease() < 0 ? -1 : 1;
						double ecv = 0;
						ecv = Math.abs(ch.getEcvIncrease())
								* ch.getSecondaryValue()
								/ ch.getEcvIncreaseLevels();
						ecv = ecv * mul;
						ecv2 += ecv;
					}
				}
				if (ecv1 == ecv2) {
					ecvTotal = "" + Rounder.roundHalfUp(ecv1);
				} else {
					ecvTotal = Rounder.roundHalfUp(ecv1) + "/"
							+ Rounder.roundHalfUp(ecv2);
				}
			}
			ret = swapValue("<!--DCV-->", dcvTotal, ret);
			ret = swapValue("<!--PRIMARY_DCV-->", "" + dcv1, ret);
			ret = swapValue("<!--SECONDARY_DCV-->", "" + dcv2, ret);
			ret = swapValue("<!--OCV-->", ocvTotal, ret);
			ret = swapValue("<!--PRIMARY_OCV-->", "" + ocv1, ret);
			ret = swapValue("<!--SECONDARY_OCV-->", "" + ocv2, ret);
			ret = swapValue("<!--ECV-->", ecvTotal, ret);
			ret = swapValue("<!--PRIMARY_ECV-->", "" + ecv1, ret);
			ret = swapValue("<!--SECONDARY_ECV-->", "" + ecv2, ret);
			// END 5ER CV HANDLING
		}
	
		// weight and cost...
		double w = 0;
		double carried = 0;
		double cost = 0;
		for (GenericObject o : hero.getEquipment()) {
			cost += o.getTotalPrice();
			w += o.getTotalWeight();
			if (o.isCarried()) {
				carried += o.getTotalWeight();
			}
		}
		BigDecimal wg = new BigDecimal(w);
		wg = wg.setScale(2, wght.ROUND_HALF_DOWN);
		BigDecimal crd = new BigDecimal(carried);
		crd = crd.setScale(2, crd.ROUND_HALF_DOWN);
		BigDecimal cst = new BigDecimal(cost);
		cst = cst.setScale(hero.getRules().getEquipmentCostDecimalPlaces(),
				cst.ROUND_HALF_DOWN);
		String costVal = "";
		if (hero.getRules().isEquipmentUnitsPrefix()) {
			costVal = hero.getRules().getEquipmentCostUnits() + cst.toString();
		} else {
			costVal = cst.toString() + hero.getRules().getEquipmentCostUnits();
		}
		ret = swapValue("<!--TOTAL_WEIGHT-->", wg.toString()
				+ " "
				+ (HeroDesigner.getInstance().getPrefs().isMetric() ? "kg"
						: "lbs"), ret);
		ret = swapValue("<!--TOTAL_CARRIED-->", crd.toString()
				+ " "
				+ (HeroDesigner.getInstance().getPrefs().isMetric() ? "kg"
						: "lbs"), ret);
		ret = swapValue("<!--TOTAL_COST-->", costVal, ret);
		// COMBAT LEVELS
		// first...cleanup...
		String clsSets = getLongValue("<!--IFCOMBAT_LEVELS-->",
				"<!--/IFCOMBAT_LEVELS-->", ret);
		String anti = getLongValue("<!--IF_NO_COMBAT_LEVELS-->",
				"<!--/IF_NO_COMBAT_LEVELS-->", ret);
		int count = 0;
		for (GenericObject o : hero.getSkills()) {
			if (o instanceof CombatLevels) {
				count++;
			} else if (o instanceof SkillLevels) {
				if ((o.getSelectedOption() != null)
						&& o.getSelectedOption().getXMLID().equals("OVERALL")) {
					count++;
				}
			}
		}
		if (count == 0) {
			for (GenericObject o : hero.getPowers()) {
				if (o instanceof CombatLevels) {
					count++;
				} else if (o instanceof SkillLevels) {
					if ((o.getSelectedOption() != null)
							&& o.getSelectedOption().getXMLID().equals(
									"OVERALL")) {
						count++;
					}
				} /*
				 * else if (o instanceof CompoundPower) { CompoundPower cp =
				 * (CompoundPower) o; for (GenericObject o2 : cp.getPowers()) {
				 * if (o2 instanceof CombatLevels) { count++; } else if (o2
				 * instanceof SkillLevels) { if ((o2.getSelectedOption() !=
				 * null) && o2.getSelectedOption().getXMLID()
				 * .equals("OVERALL")) { count++; } } } }
				 */
			}
			for (GenericObject o : hero.getEquipment()) {
				if (o instanceof CombatLevels) {
					count++;
				} else if (o instanceof SkillLevels) {
					if ((o.getSelectedOption() != null)
							&& o.getSelectedOption().getXMLID().equals(
									"OVERALL")) {
						count++;
					}
				} /*
				 * else if (o instanceof CompoundPower) { CompoundPower cp =
				 * (CompoundPower) o; for (GenericObject o2 : cp.getPowers()) {
				 * if (o2 instanceof CombatLevels) { count++; } else if (o2
				 * instanceof SkillLevels) { if ((o2.getSelectedOption() !=
				 * null) && o2.getSelectedOption().getXMLID()
				 * .equals("OVERALL")) { count++; } } } }
				 */
			}
		}
		while (clsSets != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IFCOMBAT_LEVELS-->",
						"<!--/IFCOMBAT_LEVELS-->", clsSets, ret);
			} else {
				ret = swapLongValue("<!--IFCOMBAT_LEVELS-->",
						"<!--/IFCOMBAT_LEVELS-->", "", ret);
			}
			clsSets = getLongValue("<!--IFCOMBAT_LEVELS-->",
					"<!--/IFCOMBAT_LEVELS-->", ret);
		}
		while (anti != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IF_NO_COMBAT_LEVELS-->",
						"<!--/IF_NO_COMBAT_LEVELS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_COMBAT_LEVELS-->",
						"<!--/IF_NO_COMBAT_LEVELS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_COMBAT_LEVELS-->",
					"<!--/IF_NO_COMBAT_LEVELS-->", ret);
		}
		// now swap in values....
		String cls = getCombatLevelString(ret);
		while (cls != null) {
			ret = swapLongValue("<!--COMBAT_LEVELS-->",
					"<!--/COMBAT_LEVELS-->", cls, ret);
			cls = getCombatLevelString(ret);
		}
		// LIGHTNING REFLEXES
		// first...cleanup...
		clsSets = getLongValue("<!--IF_LIGHTNING_REFLEXES-->",
				"<!--/IF_LIGHTNING_REFLEXES-->", ret);
		anti = getLongValue("<!--IF_NO_LIGHTNING_REFLEXES-->",
				"<!--/IF_NO_LIGHTNING_REFLEXES-->", ret);
		count = 0;
		for (int i = 0; i < hero.getTalents().size(); i++) {
			if ((hero.getTalents().get(i) instanceof LightningReflexesAll)
					|| (hero.getTalents().get(i) instanceof LightningReflexesSingle)) {
				count++;
			}
		}
		if (count == 0) {
			for (int i = 0; i < hero.getPowers().size(); i++) {
				if ((hero.getPowers().get(i) instanceof LightningReflexesAll)
						|| (hero.getPowers().get(i) instanceof LightningReflexesSingle)) {
					count++;
				} /*
				 * else if (hero.getPowers().get(i) instanceof CompoundPower) {
				 * CompoundPower cp = (CompoundPower) hero.getPowers().get(i);
				 * for (int j = 0; j < cp.getPowers().size(); j++) { if
				 * ((cp.getPowers().get(j) instanceof LightningReflexesAll) ||
				 * (cp.getPowers().get(j) instanceof LightningReflexesSingle)) {
				 * count++; } } }
				 */
			}
		}
		if (count == 0) {
			for (int i = 0; i < hero.getEquipment().size(); i++) {
				if ((hero.getEquipment().get(i) instanceof LightningReflexesAll)
						|| (hero.getEquipment().get(i) instanceof LightningReflexesSingle)) {
					count++;
				}/*
				 * else if (hero.getEquipment().get(i) instanceof CompoundPower)
				 * { CompoundPower cp = (CompoundPower) hero.getEquipment().get(
				 * i); for (int j = 0; j < cp.getPowers().size(); j++) { if
				 * ((cp.getPowers().get(j) instanceof LightningReflexesAll) ||
				 * (cp.getPowers().get(j) instanceof LightningReflexesSingle)) {
				 * count++; } } }
				 */
			}
		}
		while (clsSets != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IF_LIGHTNING_REFLEXES-->",
						"<!--/IF_LIGHTNING_REFLEXES-->", clsSets, ret);
			} else {
				ret = swapLongValue("<!--IF_LIGHTNING_REFLEXES-->",
						"<!--/IF_LIGHTNING_REFLEXES-->", "", ret);
			}
			clsSets = getLongValue("<!--IF_LIGHTNING_REFLEXES-->",
					"<!--/IF_LIGHTNING_REFLEXES-->", ret);
		}
		while (anti != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IF_NO_LIGHTNING_REFLEXES-->",
						"<!--/IF_NO_LIGHTNING_REFLEXES-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_LIGHTNING_REFLEXES-->",
						"<!--/IF_NO_LIGHTNING_REFLEXES-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_LIGHTNING_REFLEXES-->",
					"<!--/IF_NO_LIGHTNING_REFLEXES-->", ret);
		}
		// now swap in values....
		cls = getLightningReflexString(ret);
		while (cls != null) {
			ret = swapLongValue("<!--LIGHTNING_REFLEXES-->",
					"<!--/LIGHTNING_REFLEXES-->", cls, ret);
			cls = getLightningReflexString(ret);
		}
		// MANEUVERS
		// first...cleanup...
		String manSets = getLongValue("<!--IFMANEUVERS-->",
				"<!--/IFMANEUVERS-->", ret);
		anti = getLongValue("<!--IF_NO_MANEUVERS-->",
				"<!--/IF_NO_MANEUVERS-->", ret);
		count = 0;
		if (hero.getManeuvers().size() > 0) {
			for (int i = 0; i < hero.getManeuvers().size(); i++) {
				if (hero.getManeuvers().get(i) instanceof Maneuver) {
					count++;
				}
			}
		}
		while (manSets != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IFMANEUVERS-->",
						"<!--/IFMANEUVERS-->", manSets, ret);
			} else {
				ret = swapLongValue("<!--IFMANEUVERS-->",
						"<!--/IFMANEUVERS-->", "", ret);
			}
			manSets = getLongValue("<!--IFMANEUVERS-->", "<!--/IFMANEUVERS-->",
					ret);
		}
		while (anti != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IF_NO_MANEUVERS-->",
						"<!--/IF_NO_MANEUVERS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_MANEUVERS-->",
						"<!--/IF_NO_MANEUVERS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_MANEUVERS-->",
					"<!--/IF_NO_MANEUVERS-->", ret);
		}
		// now swap in values....
		String man = getManeuverString(ret);
		while (man != null) {
			ret = swapLongValue("<!--MANEUVERS-->", "<!--/MANEUVERS-->", man,
					ret);
			man = getManeuverString(ret);
		}
		// MANEUVERS
		// first...cleanup...
		String nonSets = getLongValue("<!--IFNONMANEUVERS-->",
				"<!--/IFNONMANEUVERS-->", ret);
		anti = getLongValue("<!--IF_NO_NONMANEUVERS-->",
				"<!--/IF_NO_NONMANEUVERS-->", ret);
		count = 0;
		if (hero.getManeuvers().size() > 0) {
			for (int i = 0; i < hero.getManeuvers().size(); i++) {
				if (!(hero.getManeuvers().get(i) instanceof Maneuver)) {
					count++;
				}
			}
		}
		while (nonSets != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IFNONMANEUVERS-->",
						"<!--/IFNONMANEUVERS-->", nonSets, ret);
			} else {
				ret = swapLongValue("<!--IFNONMANEUVERS-->",
						"<!--/IFNONMANEUVERS-->", "", ret);
			}
			nonSets = getLongValue("<!--IFNONMANEUVERS-->",
					"<!--/IFNONMANEUVERS-->", ret);
		}
		while (anti != null) {
			if (count > 0) {
				ret = swapLongValue("<!--IF_NO_NONMANEUVERS-->",
						"<!--/IF_NO_NONMANEUVERS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_NONMANEUVERS-->",
						"<!--/IF_NO_NONMANEUVERS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_NONMANEUVERS-->",
					"<!--/IF_NO_NONMANEUVERS-->", ret);
		}
		// now swap in values....
		String non = getNonManeuverString(ret);
		while (non != null) {
			ret = swapLongValue("<!--NONMANEUVERS-->", "<!--/NONMANEUVERS-->",
					non, ret);
			non = getNonManeuverString(ret);
		}
		// MARTIAL_ARTS
		// first...cleanup...
		String maSets = getLongValue("<!--IFMARTIAL_ARTS-->",
				"<!--/IFMARTIAL_ARTS-->", ret);
		anti = getLongValue("<!--IF_NO_MARTIAL_ARTS-->",
				"<!--/IF_NO_MARTIAL_ARTS-->", ret);
		while (maSets != null) {
			if (hero.getManeuvers().size() > 0) {
				ret = swapLongValue("<!--IFMARTIAL_ARTS-->",
						"<!--/IFMARTIAL_ARTS-->", maSets, ret);
			} else {
				ret = swapLongValue("<!--IFMARTIAL_ARTS-->",
						"<!--/IFMARTIAL_ARTS-->", "", ret);
			}
			maSets = getLongValue("<!--IFMARTIAL_ARTS-->",
					"<!--/IFMARTIAL_ARTS-->", ret);
		}
		while (anti != null) {
			if (hero.getManeuvers().size() > 0) {
				ret = swapLongValue("<!--IF_NO_MARTIAL_ARTS-->",
						"<!--/IF_NO_MARTIAL_ARTS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_MARTIAL_ARTS-->",
						"<!--/IF_NO_MARTIAL_ARTS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_MARTIAL_ARTS-->",
					"<!--/IF_NO_MARTIAL_ARTS-->", ret);
		}
		// now swap in values....
		String ma = getMartialArtsString(ret);
		while (ma != null) {
			ret = swapLongValue("<!--MARTIAL_ARTS-->", "<!--/MARTIAL_ARTS-->",
					ma, ret);
			ma = getMartialArtsString(ret);
		}
		// SKILLS
		// first...cleanup...
		String skillSets = getLongValue("<!--IFSKILLS-->", "<!--/IFSKILLS-->",
				ret);
		anti = getLongValue("<!--IF_NO_SKILLS-->", "<!--/IF_NO_SKILLS-->", ret);
		while (skillSets != null) {
			if (hero.getSkills().size() > 0) {
				ret = swapLongValue("<!--IFSKILLS-->", "<!--/IFSKILLS-->",
						skillSets, ret);
			} else {
				ret = swapLongValue("<!--IFSKILLS-->", "<!--/IFSKILLS-->", "",
						ret);
			}
			skillSets = getLongValue("<!--IFSKILLS-->", "<!--/IFSKILLS-->", ret);
		}
		while (anti != null) {
			if (hero.getSkills().size() > 0) {
				ret = swapLongValue("<!--IF_NO_SKILLS-->",
						"<!--/IF_NO_SKILLS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_SKILLS-->",
						"<!--/IF_NO_SKILLS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_SKILLS-->", "<!--/IF_NO_SKILLS-->",
					ret);
		}
		// now swap in values....
		String sk = getSkillString(ret);
		while (sk != null) {
			ret = swapLongValue("<!--SKILLS-->", "<!--/SKILLS-->", sk, ret);
			sk = getSkillString(ret);
		}
		// PERKS
		// first...cleanup...
		String perkSets = getLongValue("<!--IFPERKS-->", "<!--/IFPERKS-->", ret);
		anti = getLongValue("<!--IF_NO_PERKS-->", "<!--/IF_NO_PERKS-->", ret);
		while (perkSets != null) {
			if (hero.getPerks().size() > 0) {
				ret = swapLongValue("<!--IFPERKS-->", "<!--/IFPERKS-->",
						perkSets, ret);
			} else {
				ret = swapLongValue("<!--IFPERKS-->", "<!--/IFPERKS-->", "",
						ret);
			}
			perkSets = getLongValue("<!--IFPERKS-->", "<!--/IFPERKS-->", ret);
		}
		while (anti != null) {
			if (hero.getPerks().size() > 0) {
				ret = swapLongValue("<!--IF_NO_PERKS-->",
						"<!--/IF_NO_PERKS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_PERKS-->",
						"<!--/IF_NO_PERKS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_PERKS-->", "<!--/IF_NO_PERKS-->",
					ret);
		}
		// now swap in values....
		String pk = getPerkString(ret);
		while (pk != null) {
			ret = swapLongValue("<!--PERKS-->", "<!--/PERKS-->", pk, ret);
			pk = getPerkString(ret);
		}
		// TALENTS
		// first...cleanup...
		String talentSets = getLongValue("<!--IFTALENTS-->",
				"<!--/IFTALENTS-->", ret);
		anti = getLongValue("<!--IF_NO_TALENTS-->", "<!--/IF_NO_TALENTS-->",
				ret);
		while (talentSets != null) {
			if (hero.getTalents().size() > 0) {
				ret = swapLongValue("<!--IFTALENTS-->", "<!--/IFTALENTS-->",
						talentSets, ret);
			} else {
				ret = swapLongValue("<!--IFTALENTS-->", "<!--/IFTALENTS-->",
						"", ret);
			}
			talentSets = getLongValue("<!--IFTALENTS-->", "<!--/IFTALENTS-->",
					ret);
		}
		while (anti != null) {
			if (hero.getTalents().size() > 0) {
				ret = swapLongValue("<!--IF_NO_TALENTS-->",
						"<!--/IF_NO_TALENTS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_TALENTS-->",
						"<!--/IF_NO_TALENTS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_TALENTS-->",
					"<!--/IF_NO_TALENTS-->", ret);
		}
		// now swap in values....
		String tal = getTalentString(ret);
		while (tal != null) {
			ret = swapLongValue("<!--TALENTS-->", "<!--/TALENTS-->", tal, ret);
			tal = getTalentString(ret);
		}
		// DISADS
		// first...cleanup...
		String disadSets = getLongValue("<!--IFDISADS-->", "<!--/IFDISADS-->",
				ret);
		anti = getLongValue("<!--IF_NO_DISADS-->", "<!--/IF_NO_DISADS-->", ret);
		while (disadSets != null) {
			if (hero.getDisads().size() > 0) {
				ret = swapLongValue("<!--IFDISADS-->", "<!--/IFDISADS-->",
						disadSets, ret);
			} else {
				ret = swapLongValue("<!--IFDISADS-->", "<!--/IFDISADS-->", "",
						ret);
			}
			disadSets = getLongValue("<!--IFDISADS-->", "<!--/IFDISADS-->", ret);
		}
		while (anti != null) {
			if (hero.getDisads().size() > 0) {
				ret = swapLongValue("<!--IF_NO_DISADS-->",
						"<!--/IF_NO_DISADS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_DISADS-->",
						"<!--/IF_NO_DISADS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_DISADS-->", "<!--/IF_NO_DISADS-->",
					ret);
		}
		// now swap in values....
		String dis = getDisadString(ret);
		while (dis != null) {
			ret = swapLongValue("<!--DISADS-->", "<!--/DISADS-->", dis, ret);
			dis = getDisadString(ret);
		}
		// POWERS
		// first...cleanup...
		String powerSets = getLongValue("<!--IFPOWERS-->", "<!--/IFPOWERS-->",
				ret);
		anti = getLongValue("<!--IF_NO_POWERS-->", "<!--/IF_NO_POWERS-->", ret);
		while (powerSets != null) {
			if (hero.getPowers().size() > 0) {
				ret = swapLongValue("<!--IFPOWERS-->", "<!--/IFPOWERS-->",
						powerSets, ret);
			} else {
				ret = swapLongValue("<!--IFPOWERS-->", "<!--/IFPOWERS-->", "",
						ret);
			}
			powerSets = getLongValue("<!--IFPOWERS-->", "<!--/IFPOWERS-->", ret);
		}
		while (anti != null) {
			if (hero.getPowers().size() > 0) {
				ret = swapLongValue("<!--IF_NO_POWERS-->",
						"<!--/IF_NO_POWERS-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_POWERS-->",
						"<!--/IF_NO_POWERS-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_POWERS-->", "<!--/IF_NO_POWERS-->",
					ret);
		}
		// now swap in values....
		String pow = getPowerString(ret);
		while (pow != null) {
			ret = swapLongValue("<!--POWERS-->", "<!--/POWERS-->", pow, ret);
			pow = getPowerString(ret);
		}
		// EQUIPMENT
		// first...cleanup...
		String equipSets = getLongValue("<!--IFEQUIPMENT-->",
				"<!--/IFEQUIPMENT-->", ret);
		anti = getLongValue("<!--IF_NO_EQUIPMENT-->",
				"<!--/IF_NO_EQUIPMENT-->", ret);
		while (equipSets != null) {
			if (hero.getEquipment().size() > 0) {
				ret = swapLongValue("<!--IFEQUIPMENT-->",
						"<!--/IFEQUIPMENT-->", equipSets, ret);
			} else {
				ret = swapLongValue("<!--IFEQUIPMENT-->",
						"<!--/IFEQUIPMENT-->", "", ret);
			}
			equipSets = getLongValue("<!--IFEQUIPMENT-->",
					"<!--/IFEQUIPMENT-->", ret);
		}
		while (anti != null) {
			if (hero.getEquipment().size() > 0) {
				ret = swapLongValue("<!--IF_NO_EQUIPMENT-->",
						"<!--/IF_NO_EQUIPMENT-->", "", ret);
			} else {
				ret = swapLongValue("<!--IF_NO_EQUIPMENT-->",
						"<!--/IF_NO_EQUIPMENT-->", anti, ret);
			}
			anti = getLongValue("<!--IF_NO_EQUIPMENT-->",
					"<!--/IF_NO_EQUIPMENT-->", ret);
		}
		// now swap in values....
		String eq = getEquipmentString(ret);
		while (eq != null) {
			ret = swapLongValue("<!--EQUIPMENT-->", "<!--/EQUIPMENT-->", eq,
					ret);
			eq = getEquipmentString(ret);
		}
	
		String reflect = getLongValue("<!--ATTRIBUTE_VALUE-->",
				"<!--/ATTRIBUTE_VALUE-->", ret);
		while (reflect != null) {
			String attributeValue = "";
			reflect = reflect.trim().toUpperCase();
			for (Method m : hero.getClass().getMethods()) {
	
				if ((m.getName().toUpperCase().equals(reflect) || m.getName()
						.toUpperCase().equals("GET" + reflect))
						&& (m.getParameterTypes().length == 0)) {
					try {
						attributeValue = m.invoke(hero, new Object[0])
								.toString();
					} catch (Exception exp) {
						exp.printStackTrace();
					}
				}
			}
			ret = swapLongValue("<!--ATTRIBUTE_VALUE-->",
					"<!--/ATTRIBUTE_VALUE-->", attributeValue, ret);
			reflect = getLongValue("<!--ATTRIBUTE_VALUE-->",
					"<!--/ATTRIBUTE_VALUE-->", ret);
		}
	
		String math = getLongValue("<!--MATH-->", "<!--/MATH-->", ret);
		while ((math != null) && (math.trim().length() > 0)) {
			math = getMathString(math);
			ret = swapLongValue("<!--MATH-->", "<!--/MATH-->", math, ret);
			math = getLongValue("<!--MATH-->", "<!--/MATH-->", ret);
		}
		String rep = getLongValue("<!--IFREGMATCH-->", "<!--/IFREGMATCH-->",
				ret);
		while ((rep != null) && (rep.trim().length() > 0)) {
			String reg = getLongValue("<!--REGSTRING-->", "<!--/REGSTRING-->",
					rep);
			String mat = getLongValue("<!--MATCHSTRING-->",
					"<!--/MATCHSTRING-->", rep);
			rep = swapLongValue("<!--REGSTRING-->", "<!--/REGSTRING-->", "",
					rep);
			rep = swapLongValue("<!--MATCHSTRING-->", "<!--/MATCHSTRING-->",
					"", rep);
			if (mat.matches(reg)) {
				ret = swapLongValue("<!--IFREGMATCH-->", "<!--/IFREGMATCH-->",
						rep, ret);
			} else {
				ret = swapLongValue("<!--IFREGMATCH-->", "<!--/IFREGMATCH-->",
						"", ret);
			}
			rep = getLongValue("<!--IFREGMATCH-->", "<!--/IFREGMATCH-->", ret);
		}
		rep = getLongValue("<!--REPLACE-->", "<!--/REPLACE-->", ret);
		ArrayList<String[]> reps = new ArrayList<String[]>();
		while ((rep != null) && (rep.trim().length() > 0)) {
			String def = getLongValue("<!--DEFSTRING-->", "<!--/DEFSTRING-->",
					rep);
			String swp = getLongValue("<!--REPSTRING-->", "<!--/REPSTRING-->",
					rep);
			if (swp == null) {
				swp = "";
			}
			if ((def != null) && (def.trim().length() > 0) && (swp != null)) {
				reps.add(new String[] { def, swp });
			}
			ret = swapLongValue("<!--REPLACE-->", "<!--/REPLACE-->", "", ret);
			rep = getLongValue("<!--REPLACE-->", "<!--/REPLACE-->", ret);
		}
		for (int i = 0; i < reps.size(); i++) {
			String[] vals = reps.get(i);
			while (ret.indexOf(vals[0]) >= 0) {
				String part1 = ret.substring(0, ret.indexOf(vals[0]));
				String part2 = ret.substring(ret.indexOf(vals[0])
						+ vals[0].length(), ret.length());
				ret = part1 + vals[1] + part2;
			}
		}
		rep = getLongValue("<!--REG_REPLACE-->", "<!--/REG_REPLACE-->", ret);
		reps = new ArrayList<String[]>();
		while ((rep != null) && (rep.trim().length() > 0)) {
			String def = getLongValue("<!--REGSTRING-->", "<!--/REGSTRING-->",
					rep);
			String swp = getLongValue("<!--REPSTRING-->", "<!--/REPSTRING-->",
					rep);
			if (swp == null) {
				swp = "";
			}
			if ((def != null) && (def.trim().length() > 0) && (swp != null)) {
				reps.add(new String[] { def, swp });
			}
			ret = swapLongValue("<!--REG_REPLACE-->", "<!--/REG_REPLACE-->",
					"", ret);
			rep = getLongValue("<!--REG_REPLACE-->", "<!--/REG_REPLACE-->", ret);
		}
		for (String[] vals : reps) {
			ret = ret.replaceAll(vals[0], vals[1]);
		}
		byte[] imageData = null;
		String imageHex = null;
		int width = 0;
		int height = 0;
		if ((hero.getImageFileName() != null)
				&& (hero.getImageFileName().trim().length() > 0)
				&& (hero.getImageData() != null)
				&& (hero.getImageData().length > 0)
				&& (!HeroDesigner.getInstance().headless)) {
			ImageIcon icon = new ImageIcon(hero.getImageData());
			width = icon.getIconWidth();
			height = icon.getIconHeight();
			imageData = hero.getImageData();
			imageHex = Utility.toHexString(imageData);
		}
		if (imageData != null) {
			ret = swapValue("<!--IMAGE_HEX_DATA-->", imageHex, ret);
			ret = swapValue("<!--IMAGE_WIDTH-->", "" + width, ret);
			ret = swapValue("<!--IMAGE_HEIGHT-->", "" + height, ret);
			ret = swapValue("<!--IMAGE_HEX_LENGTH-->", "" + imageHex.length(),
					ret);
			ret = swapValue("<!--IMAGE_DATA_LENGTH-->", "" + imageData.length,
					ret);
			ret = swapValue("<!--IMAGE_DATA-->", new String(imageData), ret);
		}
		return ret;
	}

	private String getAdderString(String template, GenericObject obj) {
		String mas = getLongValue("<!--ADDERS-->", "<!--/ADDERS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			for (int i = 0; i < obj.getAssignedAdders().size(); i++) {
				Adder cls = obj.getAssignedAdders().get(i);
				String val = mas;
				val = getGeneralString(val, cls);
				val = swapValue("<!--ADDER_XMLID-->", cls.getXMLID(), val);
				val = swapValue("<!--ADDER_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--ADDER_ALIAS-->", cls.getAlias(), val);
				val = swapValue("<!--ADDER_TEXT-->", cls
						.getNamelessColumn2Output(), val);
				val = swapValue("<!--ADDER_COST-->", "" + cls.getTotalCost(),
						val);
				masValue += val;
			}
		}
		return masValue;
	}

	private String getCombatLevelString(String template) {
		String mas = getLongValue("<!--COMBAT_LEVELS-->",
				"<!--/COMBAT_LEVELS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			int count = 0;
			for (int i = 0; i < hero.getSkills().size(); i += step) {
				GenericObject cls = hero.getSkills().get(i);
				if (!(cls instanceof CombatLevels)) {
					if (cls instanceof SkillLevels) {
						if ((cls.getSelectedOption() == null)
								|| !cls.getSelectedOption().getXMLID().equals(
										"OVERALL")) {
							continue;
						}
					} else {
						continue;
					}
				}
				count++;
				if (count < start) {
					continue;
				}
				if (count > stop) {
					return masValue;
				}
				Skill man = (Skill) cls;
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				val = swapValue("<!--COMBAT_LEVEL_COST-->", man
						.getColumn1Output(), val);
				val = swapValue("<!--COMBAT_LEVEL_TEXT-->", man
						.getNamelessColumn2Output(), val);
				val = swapValue("<!--COMBAT_LEVEL_DISPLAY-->",
						cls.getDisplay(), val);
				val = swapValue("<!--COMBAT_LEVEL_ALIAS-->", cls.getAlias(),
						val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--COMBAT_LEVEL_NOTES-->", cls
							.getOutputNotes(), val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "", val);
				}
				masValue += val;
			}
			if (count < stop) {
				for (int i = 0; i < hero.getPowers().size(); i++) {
					GenericObject cls = hero.getPowers().get(i);
					/*
					 * if (cls instanceof CompoundPower) { CompoundPower cp =
					 * (CompoundPower) cls; for (int j = 0; j <
					 * cp.getPowers().size(); j++) { cls =
					 * cp.getPowers().get(j); if (!(cls instanceof
					 * CombatLevels)) { if (cls instanceof SkillLevels) { if
					 * ((cls.getSelectedOption() == null) ||
					 * !cls.getSelectedOption() .getXMLID().equals( "OVERALL"))
					 * { continue; } } else { continue; } } count++; if (count <
					 * start) { continue; } if (count > stop) { return masValue;
					 * } Skill man = (Skill) cls; if (masValue.trim().length() >
					 * 0) { masValue += separator; } String val = mas; val =
					 * getGeneralString(val, cls); String text =
					 * cls.getNamelessColumn2Output(); if (cls.getParentList()
					 * != null) { text = text +
					 * cls.getParentList().getColumn2Suffix( cls); } val =
					 * swapValue("<!--COMBAT_LEVEL_COST-->", man
					 * .getColumn1Output(), val); val =
					 * swapValue("<!--COMBAT_LEVEL_TEXT-->", text, val); val =
					 * swapValue("<!--COMBAT_LEVEL_DISPLAY-->", cls
					 * .getDisplay(), val); val =
					 * swapValue("<!--COMBAT_LEVEL_ALIAS-->", cls .getAlias(),
					 * val); if (cls.isIncludeNotesInPrintout()) { val =
					 * swapValue("<!--COMBAT_LEVEL_NOTES-->",
					 * cls.getOutputNotes(), val); } else if (cls.getQuantity()
					 * > 1) { val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "(x"
					 * + cls.getQuantity() + " number of items)", val); } else {
					 * val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "", val); }
					 * masValue += val; } continue; }
					 */
					if (!(cls instanceof CombatLevels)) {
						if (cls instanceof SkillLevels) {
							if ((cls.getSelectedOption() == null)
									|| !cls.getSelectedOption().getXMLID()
											.equals("OVERALL")) {
								continue;
							}
						} else {
							continue;
						}
					}
					count++;
					if (count < start) {
						continue;
					}
					if (count > stop) {
						return masValue;
					}
					Skill man = (Skill) cls;
					if (masValue.trim().length() > 0) {
						masValue += separator;
					}
					String val = mas;
					val = getGeneralString(val, cls);
					String text = cls.getNamelessColumn2Output();
					if (cls.getParentList() != null) {
						text = text + cls.getParentList().getColumn2Suffix(cls);
					}
					val = swapValue("<!--COMBAT_LEVEL_COST-->", man
							.getColumn1Output(), val);
					val = swapValue("<!--COMBAT_LEVEL_TEXT-->", text, val);
					val = swapValue("<!--COMBAT_LEVEL_DISPLAY-->", cls
							.getDisplay(), val);
					val = swapValue("<!--COMBAT_LEVEL_ALIAS-->",
							cls.getAlias(), val);
					if (cls.isIncludeNotesInPrintout()) {
						val = swapValue("<!--COMBAT_LEVEL_NOTES-->", cls
								.getOutputNotes(), val);
					} else if (cls.getQuantity() > 1) {
						val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "(x"
								+ cls.getQuantity() + " number of items)", val);
					} else {
						val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "", val);
					}
					masValue += val;
				}
				for (int i = 0; i < hero.getEquipment().size(); i++) {
					GenericObject cls = hero.getEquipment().get(i);
					/*
					 * if (cls instanceof CompoundPower) { CompoundPower cp =
					 * (CompoundPower) cls; for (int j = 0; j <
					 * cp.getPowers().size(); j++) { cls =
					 * cp.getPowers().get(j); if (!(cls instanceof
					 * CombatLevels)) { if (cls instanceof SkillLevels) { if
					 * ((cls.getSelectedOption() == null) ||
					 * !cls.getSelectedOption() .getXMLID().equals( "OVERALL"))
					 * { continue; } } else { continue; } } count++; if (count <
					 * start) { continue; } if (count > stop) { return masValue;
					 * } Skill man = (Skill) cls; if (masValue.trim().length() >
					 * 0) { masValue += separator; } String val = mas; val =
					 * getGeneralString(val, cls); String text =
					 * cls.getNamelessColumn2Output(); if (cls.getParentList()
					 * != null) { text = text +
					 * cls.getParentList().getColumn2Suffix( cls); } val =
					 * swapValue("<!--COMBAT_LEVEL_COST-->", man
					 * .getColumn1Output(), val); val =
					 * swapValue("<!--COMBAT_LEVEL_TEXT-->", text, val); val =
					 * swapValue("<!--COMBAT_LEVEL_DISPLAY-->", cls
					 * .getDisplay(), val); val =
					 * swapValue("<!--COMBAT_LEVEL_ALIAS-->", cls .getAlias(),
					 * val); if (cls.isIncludeNotesInPrintout()) { val =
					 * swapValue("<!--COMBAT_LEVEL_NOTES-->",
					 * cls.getOutputNotes(), val); } else if (cls.getQuantity()
					 * > 1) { val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "(x"
					 * + cls.getQuantity() + " number of items)", val); } else {
					 * val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "", val); }
					 * masValue += val; } continue; }
					 */
					if (!(cls instanceof CombatLevels)) {
						if (cls instanceof SkillLevels) {
							if ((cls.getSelectedOption() == null)
									|| !cls.getSelectedOption().getXMLID()
											.equals("OVERALL")) {
								continue;
							}
						} else {
							continue;
						}
					}
					count++;
					if (count < start) {
						continue;
					}
					if (count > stop) {
						return masValue;
					}
					Skill man = (Skill) cls;
					if (masValue.trim().length() > 0) {
						masValue += separator;
					}
					String val = mas;
					val = getGeneralString(val, cls);
					String text = cls.getNamelessColumn2Output();
					if (cls.getParentList() != null) {
						text = text + cls.getParentList().getColumn2Suffix(cls);
					}
					val = swapValue("<!--COMBAT_LEVEL_COST-->", man
							.getColumn1Output(), val);
					val = swapValue("<!--COMBAT_LEVEL_TEXT-->", text, val);
					val = swapValue("<!--COMBAT_LEVEL_DISPLAY-->", cls
							.getDisplay(), val);
					val = swapValue("<!--COMBAT_LEVEL_ALIAS-->",
							cls.getAlias(), val);
					if (cls.isIncludeNotesInPrintout()) {
						val = swapValue("<!--COMBAT_LEVEL_NOTES-->", cls
								.getOutputNotes(), val);
					} else if (cls.getQuantity() > 1) {
						val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "(x"
								+ cls.getQuantity() + " number of items)", val);
					} else {
						val = swapValue("<!--COMBAT_LEVEL_NOTES-->", "", val);
					}
					masValue += val;
				}
			}
		}
		return masValue;
	}

	private String getCompoundPowerString(String template, CompoundPower cp) {
		String mas = getLongValue("<!--COMPONENT_POWERS-->",
				"<!--/COMPONENT_POWERS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < cp.getPowers().size()) && (i < stop); i += step) {
				GenericObject cls = cp.getPowers().get(i);
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String text = cls.getNamelessColumn2Output();
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				if (cls instanceof Power) {
					val = swapValue("<!--POWER_RANGE-->", ""
							+ cls.getRangeDisplay(), val);
					val = swapValue("<!--POWER_DMG-->", ""
							+ ((Power) cls).getDamageDisplay(), val);
				} else {
					val = swapValue("<!--POWER_RANGE-->", "", val);
					val = swapValue("<!--POWER_DMG-->", "", val);
				}
				val = swapValue("<!--POWER_END-->", cls.getColumn3Output(), val);
				masValue += val;
			}
		}
		return swapAllLongValues("<!--COMPONENT_POWERS-->",
				"<!--/COMPONENT_POWERS-->", masValue, template);
	}

	/**
	 * Returns the description of the export template.
	 * 
	 * @return
	 */
	public String getDescription() {
		String desc = getLongValue("<!--TEMPLATE_DESCRIPTION-->",
				"<!--/TEMPLATE_DESCRIPTION-->", raw);
		if ((desc == null) || (desc.trim().length() == 0)) {
			desc = "No description available.";
		}
		return desc;
	}

	private String getDisadString(String template) {
		String mas = getLongValue("<!--DISADS-->", "<!--/DISADS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if (check != null) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if (check != null) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if (check != null) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getDisads().size()) && (i < stop); i += step) {
				GenericObject cls = hero.getDisads().get(i);
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String text = cls.getNamelessColumn2Output();
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--DISAD_COST-->", cls.getColumn1Output(),
						val);
				val = swapValue("<!--DISAD_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--DISAD_ALIAS-->", cls.getAlias(), val);
				val = swapValue("<!--DISAD_TEXT-->", text, val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--DISAD_NOTES-->", cls.getOutputNotes(),
							val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--DISAD_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--DISAD_NOTES-->", "", val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	private String getEquipmentString(String template) {
		String mas = getLongValue("<!--EQUIPMENT-->", "<!--/EQUIPMENT-->",
				template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			String compoundSeparator = getLongValue(
					"<!--COMPOUND_POWER_SEPARATOR-->",
					"<!--/COMPOUND_POWER_SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			if (compoundSeparator == null) {
				compoundSeparator = " plus ";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapLongValue("<!--SEPARATOR-->", "<!--/SEPARATOR-->", "",
					mas);
			mas = swapLongValue("<!--COMPOUND_POWER_SEPARATOR-->",
					"<!--/COMPOUND_POWER_SEPARATOR-->", "", mas);
			mas = swapLongValue("<!--START-->", "<!--/START-->", "", mas);
			mas = swapLongValue("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapLongValue("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getEquipment().size())
					&& (i < stop); i += step) {
				GenericObject cls = hero.getEquipment().get(i);
				String val = mas;
				if (cls.isCarried()) {
					String ifcarried = getLongValue("<!--IF_CARRIED-->",
							"<!--/IF_CARRIED-->", val);
					while ((ifcarried != null)
							&& (ifcarried.trim().length() > 0)) {
						val = swapLongValue("<!--IF_CARRIED-->",
								"<!--/IF_CARRIED-->", ifcarried, val);
						ifcarried = getLongValue("<!--IF_CARRIED-->",
								"<!--/IF_CARRIED-->", val);
					}
					val = swapAllLongValues("<!--IF_NOT_CARRIED-->",
							"<!--/IF_NOT_CARRIED-->", "", val);
				} else {
					String ifcarried = getLongValue("<!--IF_NOT_CARRIED-->",
							"<!--/IF_NOT_CARRIED-->", val);
					while ((ifcarried != null)
							&& (ifcarried.trim().length() > 0)) {
						val = swapLongValue("<!--IF_NOT_CARRIED-->",
								"<!--/IF_NOT_CARRIED-->", ifcarried, val);
						ifcarried = getLongValue("<!--IF_NOT_CARRIED-->",
								"<!--/IF_NOT_CARRIED-->", val);
					}
					val = swapAllLongValues("<!--IF_CARRIED-->",
							"<!--/IF_CARRIED-->", "", val);
				}
				if (cls instanceof CompoundPower) {
					CompoundPower cp = (CompoundPower) cls;
					String ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
							"<!--/IF_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						ifcp = getCompoundPowerString(ifcp, cp);
						val = swapLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", ifcp, val);
						ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", val);
					}
					ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
							"<!--/IF_NOT_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						val = swapLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", "", val);
						ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", val);
					}
				} else {
					String ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
							"<!--/IF_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						val = swapLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", "", val);
						ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", val);
					}
					ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
							"<!--/IF_NOT_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						val = swapLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", ifcp, val);
						ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", val);
					}
				}
				String text = cls.getNamelessColumn2Output();
				if (cls instanceof CompoundPower) {
					CompoundPower pow = (CompoundPower) cls;
					String sep = pow.getListSeparator();
					pow.setListSeparator(compoundSeparator);
					text = pow.getNamelessColumn2Output();
					pow.setListSeparator(sep);
				}
				String nameString = getLongValue("<!--IFNAME-->",
						"<!--/IFNAME-->", val);
				while (nameString != null) {
					if ((cls.getName() != null)
							&& (cls.getName().trim().length() > 0)) {
						nameString = swapValue("<!--NAME-->", cls.getName(),
								nameString);
					} else {
						nameString = "";
					}
					val = swapLongValue("<!--IFNAME-->", "<!--/IFNAME-->",
							nameString, val);
					nameString = getLongValue("<!--IFNAME-->",
							"<!--/IFNAME-->", val);
				}

				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--EQUIPMENT_TEXT-->", text, val);
				val = swapValue("<!--TEXT-->", text, val);
				val = getGeneralString(val, cls);
				String mp = getLongValue("<!--IS_MP-->", "<!--/IS_MP-->", val);
				while (mp != null) {
					if (cls instanceof Multipower) {
						val = swapLongValue("<!--IS_MP-->", "<!--/IS_MP-->",
								mp, val);
					} else {
						val = swapLongValue("<!--IS_MP-->", "<!--/IS_MP-->",
								"", val);
					}
					mp = getLongValue("<!--IS_MP-->", "<!--/IS_MP-->", val);
				}
				mp = getLongValue("<!--IS_EC-->", "<!--/IS_EC-->", val);
				while (mp != null) {
					if (cls instanceof ElementalControl) {
						val = swapLongValue("<!--IS_EC-->", "<!--/IS_EC-->",
								mp, val);
					} else {
						val = swapLongValue("<!--IS_EC-->", "<!--/IS_EC-->",
								"", val);
					}
					mp = getLongValue("<!--IS_EC-->", "<!--/IS_EC-->", val);
				}
				mp = getLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->", val);
				while (mp != null) {
					if (cls instanceof VariablePowerPool) {
						val = swapLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->",
								mp, val);
					} else {
						val = swapLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->",
								"", val);
					}
					mp = getLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->", val);
				}
				val = swapValue("<!--EQUIPMENT_COST-->",
						cls.getColumn1Output(), val);
				val = swapValue("<!--EQUIPMENT_DISPLAY-->", cls.getDisplay(),
						val);
				val = swapValue("<!--EQUIPMENT_ALIAS-->", cls.getAlias(), val);
				if (cls instanceof Power) {
					val = swapValue("<!--EQUIPMENT_RANGE-->", ""
							+ cls.getRangeDisplay(), val);
					val = swapValue("<!--EQUIPMENT_DMG-->", ""
							+ ((Power) cls).getDamageDisplay(), val);
				} else {
					val = swapValue("<!--EQUIPMENT_RANGE-->", "", val);
					val = swapValue("<!--EQUIPMENT_DMG-->", "", val);
				}
				val = swapValue("<!--EQUIPMENT_END-->", cls.getColumn3Output(),
						val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--EQUIPMENT_NOTES-->", cls
							.getOutputNotes(), val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--EQUIPMENT_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--EQUIPMENT_NOTES-->", "", val);
				}
				BigDecimal bd = new BigDecimal(cls.getPrice());
				bd = bd.setScale(hero.getRules()
						.getEquipmentCostDecimalPlaces(), bd.ROUND_HALF_UP);
				String price = bd.toString();
				bd = new BigDecimal(cls.getTotalPrice());
				bd = bd.setScale(hero.getRules()
						.getEquipmentCostDecimalPlaces(), bd.ROUND_HALF_UP);
				String totalPrice = bd.toString();
				if (hero.getRules().isEquipmentUnitsPrefix()) {
					price = hero.getRules().getEquipmentCostUnits() + price;
					totalPrice = hero.getRules().getEquipmentCostUnits()
							+ totalPrice;
				} else {
					price = price + hero.getRules().getEquipmentCostUnits();
					totalPrice = totalPrice
							+ hero.getRules().getEquipmentCostUnits();
				}
				if (cls.getPrice() != 0) {
					val = swapValue("<!--EQUIPMENT_VALUE-->", price, val);
				} else {
					val = swapValue("<!--EQUIPMENT_VALUE-->", "", val);
				}

				if (cls.getTotalPrice() != 0) {
					val = swapValue("<!--EQUIPMENT_TOTAL_VALUE-->", totalPrice,
							val);
				} else {
					val = swapValue("<!--EQUIPMENT_TOTAL_VALUE-->", "", val);
				}
				bd = new BigDecimal(cls.getWeight());
				bd = bd.setScale(2, bd.ROUND_HALF_UP);
				String weight = bd.toString();
				bd = new BigDecimal(cls.getTotalWeight());
				bd = bd.setScale(2, bd.ROUND_HALF_UP);
				String totalWeight = bd.toString();
				if (HeroDesigner.getInstance().getPrefs().isMetric()) {
					weight += "kg";
					totalWeight += "kg";
				} else {
					weight += "lbs";
					totalWeight += "lbs";
				}
				if (cls.getWeight() != 0) {
					val = swapValue("<!--EQUIPMENT_WEIGHT-->", weight, val);
				} else {
					val = swapValue("<!--EQUIPMENT_WEIGHT-->", "", val);
				}
				if (cls.getTotalWeight() != 0) {
					val = swapValue("<!--EQUIPMENT_TOTAL_WEIGHT-->",
							totalWeight, val);
				} else {
					val = swapValue("<!--EQUIPMENT_TOTAL_WEIGHT-->", "", val);
				}
				if ((masValue.trim().length() > 0) && (val.trim().length() > 0)) {
					masValue += separator;
				}
				if (val.trim().length() > 0) {
					masValue += val;
				}
			}
		}
		return masValue;
	}

	/**
	 * Returns the list of valid file extensions defined in the template.
	 * 
	 * @return
	 */
	public ArrayList<String> getFileExtensions() {
		if (fileExtensions == null) {
			fileExtensions = new ArrayList<String>();
			String ext = getLongValue("<!--FILE_EXTENSION-->",
					"<!--/FILE_EXTENSION-->", raw);
			while (ext != null) {
				fileExtensions.add(ext.trim().toUpperCase());
				raw = swapLongValue("<!--FILE_EXTENSION-->",
						"<!--/FILE_EXTENSION-->", "", raw);
				ext = getLongValue("<!--FILE_EXTENSION-->",
						"<!--/FILE_EXTENSION-->", raw);
			}
		}
		return fileExtensions;
	}

	private String getGeneralCharString(String ret, String chStr,
			Characteristic ch) {
		int primary = (int) Rounder.roundHalfUp(ch.getPrimaryValue());
		int secondary = (int) Rounder.roundHalfUp(ch.getSecondaryValue());
		if (ch instanceof Leaping) {
			Leaping leaping = (Leaping) ch;
			primary = (int) Rounder.roundHalfUp(leaping.getPrimaryForward());
			secondary = (int) Rounder
					.roundHalfUp(leaping.getSecondaryForward());
		}
		String tmp = swapValue("<!--" + chStr + "_VAL-->", ""
				+ Rounder.roundHalfUp(ch.getCharacteristicValue()), ret);
		tmp = swapValue("<!--" + chStr + "_NAME-->", ch.getDisplay(), tmp);
		tmp = swapValue("<!--" + chStr + "_PRIMARY-->", "" + primary, tmp);
		tmp = swapValue("<!--" + chStr + "_SECONDARY-->", "" + secondary, tmp);
		tmp = swapValue("<!--" + chStr + "_SECONDARY_INCREASE-->", ""
				+ (secondary - primary), tmp);
		tmp = swapValue("<!--" + chStr + "_BASE-->", ""
				+ Rounder.roundHalfUp(ch.getBaseValue()), tmp);
		tmp = swapValue("<!--" + chStr + "_COST-->", ""
				+ Rounder.roundUp(ch.getRealCost()), tmp);
		tmp = swapValue("<!--" + chStr + "_TOTAL-->", ch.getValueDisplay(), tmp);
		tmp = swapValue("<!--" + chStr + "_ROLL-->", ch.getRoll(), tmp);
		tmp = swapValue("<!--" + chStr + "_NOTES-->", ch.getDisplayNotes(), tmp);
		tmp = swapValue("<!--" + chStr + "_ACTIVE_COST-->", ""
				+ Rounder.roundUp(ch.getActiveCost()), tmp);
		tmp = swapValue("<!--VAL-->", ""
				+ Rounder.roundHalfUp(ch.getCharacteristicValue()), tmp);
		tmp = swapValue("<!--PRIMARY-->", "" + primary, tmp);
		tmp = swapValue("<!--SECONDARY-->", "" + secondary, tmp);
		tmp = swapValue("<!--SECONDARY_INCREASE-->",
				"" + (secondary - primary), tmp);
		tmp = swapValue("<!--BASE-->", ""
				+ Rounder.roundHalfUp(ch.getBaseValue()), tmp);
		tmp = swapValue("<!--COST-->", "" + Rounder.roundUp(ch.getRealCost()),
				tmp);
		tmp = swapValue("<!--TOTAL-->", ch.getValueDisplay(), tmp);
		tmp = swapValue("<!--ROLL-->", ch.getRoll(), tmp);
		tmp = swapValue("<!--PRIMARY_ROLL-->", ""
				+ (int) (9 + Rounder.roundHalfUp((primary / 5d))), tmp);
		tmp = swapValue("<!--SECONDARY_ROLL-->", ""
				+ (int) (9 + Rounder.roundHalfUp((secondary / 5d))), tmp);
		tmp = swapValue("<!--NOTES-->", ch.getDisplayNotes(), tmp);
		tmp = swapValue("<!--ACTIVE_COST-->", ""
				+ Rounder.roundUp(ch.getActiveCost()), tmp);
		String check = getLongValue("<!--IF_SECONDARY-->",
				"<!--/IF_SECONDARY-->", tmp);
		while (check != null) {
			if (secondary - primary == 0) {
				check = "";
			}
			tmp = swapLongValue("<!--IF_SECONDARY-->", "<!--/IF_SECONDARY-->",
					check, tmp);
			check = getLongValue("<!--IF_SECONDARY-->", "<!--/IF_SECONDARY-->",
					tmp);
		}
		tmp = getGeneralString(tmp, ch);
		return tmp;
	}

	private String getGeneralString(String template, GenericObject cls) {
		String val = template;
		val = swapLongValue("<!--MODIFIERS-->", "<!--/MODIFIERS-->",
				getModifierString(val, cls), val);
		val = swapLongValue("<!--ADDERS-->", "<!--/ADDERS-->", getAdderString(
				val, cls), val);
		val = filterByType(val, "ATTACK", cls);
		val = filterByType(val, "DEFENSE", cls);
		val = filterByType(val, "MOVEMENT", cls);
		val = filterByType(val, "MENTAL", cls);
		val = filterByType(val, "SPECIAL", cls);
		val = filterByType(val, "ADJUSTMENT", cls);
		val = filterByType(val, "SENSORY", cls);
		val = filterByType(val, "SENSEAFFECTING", cls);
		val = filterByType(val, "BODYAFFECTING", cls);

		String reflect = getLongValue("<!--ATTRIBUTE_VALUE-->",
				"<!--/ATTRIBUTE_VALUE-->", val);
		while (reflect != null) {
			String attributeValue = "";
			reflect = reflect.trim().toUpperCase();
			for (Method m : cls.getClass().getMethods()) {

				if ((m.getName().toUpperCase().equals(reflect) || m.getName()
						.toUpperCase().equals("GET" + reflect))
						&& (m.getParameterTypes().length == 0)) {
					try {
						attributeValue = m.invoke(cls, new Object[0])
								.toString();
					} catch (Exception exp) {
						exp.printStackTrace();
					}
				}
			}
			val = swapLongValue("<!--ATTRIBUTE_VALUE-->",
					"<!--/ATTRIBUTE_VALUE-->", attributeValue, val);
			reflect = getLongValue("<!--ATTRIBUTE_VALUE-->",
					"<!--/ATTRIBUTE_VALUE-->", val);
		}

		String nameString = getLongValue("<!--IFNAME-->", "<!--/IFNAME-->", val);
		while (nameString != null) {
			if ((cls.getName() != null) && (cls.getName().trim().length() > 0)) {
				nameString = swapValue("<!--NAME-->", cls.getName(), nameString);
			} else {
				nameString = "";
			}
			val = swapLongValue("<!--IFNAME-->", "<!--/IFNAME-->", nameString,
					val);
			nameString = getLongValue("<!--IFNAME-->", "<!--/IFNAME-->", val);
		}
		String multString = getLongValue("<!--IFMULTIPLIER-->",
				"<!--/IFMULTIPLIER-->", val);
		while (multString != null) {
			if (cls.getMultiplier() != 1) {
				multString = swapValue("<!--MULTIPLIER-->", NumberFormat
						.getInstance().format(cls.getMultiplier()), multString);
			} else {
				multString = "";
			}
			val = swapLongValue("<!--IFMULTIPLIER-->", "<!--/IFMULTIPLIER-->",
					multString, val);
			multString = getLongValue("<!--IFMULTIPLIER-->",
					"<!--/IFMULTIPLIER-->", val);
		}
		String notes = getLongValue("<!--IFNOTES-->", "<!--/IFNOTES-->", val);
		while (notes != null) {
			if ((cls.getOutputNotes() != null)
					&& (cls.getOutputNotes().trim().length() > 0)
					&& (cls.isIncludeNotesInPrintout() || (cls.getQuantity() > 1))) {
				val = swapLongValue("<!--IFNOTES-->", "<!--/IFNOTES-->", notes,
						val);
			} else {
				val = swapLongValue("<!--IFNOTES-->", "<!--/IFNOTES-->", "",
						val);
			}
			notes = getLongValue("<!--IFNOTES-->", "<!--/IFNOTES-->", val);
		}
		String input = getLongValue("<!--IF_INPUT-->", "<!--/IF_INPUT-->", val);
		while (input != null) {
			if ((cls.getInput() != null)
					&& (cls.getInput().trim().length() > 0)) {
				val = swapLongValue("<!--IF_INPUT-->", "<!--/IF_INPUT-->",
						input, val);
			} else {
				val = swapLongValue("<!--IF_INPUT-->", "<!--/IF_INPUT-->", "",
						val);
			}
			input = getLongValue("<!--IF_INPUT-->", "<!--/IF_INPUT-->", val);
		}
		String noinput = getLongValue("<!--IF_NO_INPUT-->",
				"<!--/IF_NO_INPUT-->", val);
		while (noinput != null) {
			if ((cls.getInput() != null)
					&& (cls.getInput().trim().length() > 0)) {
				val = swapLongValue("<!--IF_NO_INPUT-->",
						"<!--/IF_NO_INPUT-->", "", val);
			} else {
				val = swapLongValue("<!--IF_NO_INPUT-->",
						"<!--/IF_NO_INPUT-->", noinput, val);
			}
			noinput = getLongValue("<!--IF_NO_INPUT-->", "<!--/IF_NO_INPUT-->",
					val);
		}
		String option = getLongValue("<!--IF_OPTION-->", "<!--/IF_OPTION-->",
				val);
		while (option != null) {
			if ((cls.getSelectedOption() != null && cls.getSelectedOption()
					.getAlias().trim().length() > 0)) {
				val = swapLongValue("<!--IF_OPTION-->", "<!--/IF_OPTION-->",
						option, val);
			} else {
				val = swapLongValue("<!--IF_OPTION-->", "<!--/IF_OPTION-->",
						"", val);
			}
			option = getLongValue("<!--IF_OPTION-->", "<!--/IF_OPTION-->", val);
		}
		String nooption = getLongValue("<!--IF_NO_OPTION-->",
				"<!--/IF_NO_OPTION-->", val);
		while (nooption != null) {
			if ((cls.getSelectedOption() != null && cls.getSelectedOption()
					.getAlias().trim().length() > 0)) {
				val = swapLongValue("<!--IF_NO_OPTION-->",
						"<!--/IF_NO_OPTION-->", "", val);
			} else {
				val = swapLongValue("<!--IF_NO_OPTION-->",
						"<!--/IF_NO_OPTION-->", nooption, val);
			}
			nooption = getLongValue("<!--IF_NO_OPTION-->",
					"<!--/IF_NO_OPTION-->", val);
		}
		String mp = getLongValue("<!--IS_LIST-->", "<!--/IS_LIST-->", val);
		while (mp != null) {
			if ((cls instanceof com.hero.objects.List)
					&& (cls.getAlias().trim().length() > 0)) {
				List list = (List) cls;
				double total = list.getRealCost();
				double totalActive = list.getActiveCost();
				for (int i = 0; i < list.getObjects().size(); i++) {
					GenericObject o = list.getObjects().get(i);
					total += o.getRealCost();
					totalActive += o.getActiveCost();
				}
				mp = swapValue("<!--REAL_COST_TOTAL-->", ""
						+ Rounder.roundUp(total), mp);
				mp = swapValue("<!--ACTIVE_COST_TOTAL-->", ""
						+ Rounder.roundUp(totalActive), mp);
				val = swapLongValue("<!--IS_LIST-->", "<!--/IS_LIST-->", mp,
						val);
			} else {
				val = swapLongValue("<!--IS_LIST-->", "<!--/IS_LIST-->", "",
						val);
			}
			mp = getLongValue("<!--IS_LIST-->", "<!--/IS_LIST-->", val);
		}
		mp = getLongValue("<!--IS_NOT_LIST-->", "<!--/IS_NOT_LIST-->", val);
		while (mp != null) {
			if (cls instanceof com.hero.objects.List) {
				val = swapLongValue("<!--IS_NOT_LIST-->",
						"<!--/IS_NOT_LIST-->", "", val);
			} else {
				val = swapLongValue("<!--IS_NOT_LIST-->",
						"<!--/IS_NOT_LIST-->", mp, val);
			}
			mp = getLongValue("<!--IS_NOT_LIST-->", "<!--/IS_NOT_LIST-->", val);
		}
		mp = getLongValue("<!--IS_SEPARATOR-->", "<!--/IS_SEPARATOR-->", val);
		while (mp != null) {
			if ((cls instanceof com.hero.objects.List)
					&& (cls.getAlias().trim().length() == 0)) {
				val = swapLongValue("<!--IS_SEPARATOR-->",
						"<!--/IS_SEPARATOR-->", mp, val);
			} else {
				val = swapLongValue("<!--IS_SEPARATOR-->",
						"<!--/IS_SEPARATOR-->", "", val);
			}
			mp = getLongValue("<!--IS_SEPARATOR-->", "<!--/IS_SEPARATOR-->",
					val);
		}
		mp = getLongValue("<!--IS_NOT_SEPARATOR-->",
				"<!--/IS_NOT_SEPARATOR-->", val);
		while (mp != null) {
			if ((cls instanceof com.hero.objects.List)
					&& (cls.getAlias().trim().length() == 0)) {
				val = swapLongValue("<!--IS_NOT_SEPARATOR-->",
						"<!--/IS_NOT_SEPARATOR-->", "", val);
			} else {
				val = swapLongValue("<!--IS_NOT_SEPARATOR-->",
						"<!--/IS_NOT_SEPARATOR-->", mp, val);
			}
			mp = getLongValue("<!--IS_NOT_SEPARATOR-->",
					"<!--/IS_NOT_SEPARATOR-->", val);
		}
		String list = getLongValue("<!--IFLIST-->", "<!--/IFLIST-->", val);
		while (list != null) {
			if ((cls.getParentList() != null)
					|| (cls.getEnhancerApplied() != null)) {
				com.hero.objects.List parent = null;
				if (cls.getEnhancerApplied() != null) {
					parent = cls.getEnhancerApplied();
				} else {
					parent = cls.getParentList();
				}
				list = swapValue("<!--LISTPREFIX-->", parent
						.getColumn2Prefix(cls), list);
				val = swapLongValue("<!--IFLIST-->", "<!--/IFLIST-->", list,
						val);
			} else {
				val = swapLongValue("<!--IFLIST-->", "<!--/IFLIST-->", "", val);
			}
			list = getLongValue("<!--IFLIST-->", "<!--/IFLIST-->", val);
		}
		list = getLongValue("<!--IS_LIST_ITEM-->", "<!--/IS_LIST_ITEM-->", val);
		while (list != null) {
			if ((cls.getParentList() != null)
					|| (cls.getEnhancerApplied() != null)) {
				com.hero.objects.List parent = null;
				if (cls.getEnhancerApplied() != null) {
					parent = cls.getEnhancerApplied();
				} else {
					parent = cls.getParentList();
				}
				list = swapValue("<!--LISTPREFIX-->", parent
						.getColumn2Prefix(cls), list);
				val = swapLongValue("<!--IS_LIST_ITEM-->",
						"<!--/IS_LIST_ITEM-->", list, val);
			} else {
				val = swapLongValue("<!--IS_LIST_ITEM-->",
						"<!--/IS_LIST_ITEM-->", "", val);
			}
			list = getLongValue("<!--IS_LIST_ITEM-->", "<!--/IS_LIST_ITEM-->",
					val);
		}
		list = getLongValue("<!--IS_NOT_LIST_ITEM-->",
				"<!--/IS_NOT_LIST_ITEM-->", val);
		while (list != null) {
			if ((cls.getParentList() == null)
					&& (cls.getEnhancerApplied() == null)) {
				val = swapLongValue("<!--IS_NOT_LIST_ITEM-->",
						"<!--/IS_NOT_LIST_ITEM-->", list, val);
			} else {
				val = swapLongValue("<!--IS_NOT_LIST_ITEM-->",
						"<!--/IS_NOT_LIST_ITEM-->", "", val);
			}
			list = getLongValue("<!--IS_NOT_LIST_ITEM-->",
					"<!--/IS_NOT_LIST_ITEM-->", val);
		}
		String endValue = getLongValue("<!--IF_END-->", "<!--/IF_END-->", val);
		if (endValue != null) {
			if ((cls.getColumn3Output().trim().length() == 0)
					|| cls.getColumn3Output().equals("0")) {
				val = swapLongValue("<!--IF_END-->", "<!--/IF_END-->", "", val);
			} else {
				val = swapLongValue("<!--IF_END-->", "<!--/IF_END-->",
						endValue, val);
			}
		}
		val = swapValue("<!--XMLID-->", cls.getXMLID(), val);
		val = swapValue("<!--UNIQUEID-->", "" + cls.getID(), val);
		val = swapValue("<!--LEVELS-->", "" + cls.getLevels(), val);
		String text = cls.getNamelessColumn2Output();
		if (cls.getParentList() != null) {
			text = text + cls.getParentList().getColumn2Suffix(cls);
		}
		val = swapValue("<!--COST-->", "" + Rounder.roundUp(cls.getRealCost()),
				val);
		mp = getLongValue("<!--IF_NOT_DEFAULT_SFX-->",
				"<!--/IF_NOT_DEFAULT_SFX-->", val);
		while (mp != null) {
			if (cls.getSFX().trim().equalsIgnoreCase("Default")) {
				val = swapLongValue("<!--IF_NOT_DEFAULT_SFX-->",
						"<!--/IF_NOT_DEFAULT_SFX-->", "", val);
			} else {
				val = swapLongValue("<!--IF_NOT_DEFAULT_SFX-->",
						"<!--/IF_NOT_DEFAULT_SFX-->", mp, val);
			}
			mp = getLongValue("<!--IF_NOT_DEFAULT_SFX-->",
					"<!--/IF_NOT_DEFAULT_SFX-->", val);
		}
		mp = getLongValue("<!--IF_RANGED-->", "<!--/IF_RANGED-->", val);
		while (mp != null) {
			if (cls.getRangeValue() == 0) {
				val = swapLongValue("<!--IF_RANGED-->", "<!--/IF_RANGED-->",
						"", val);
			} else {
				val = swapLongValue("<!--IF_RANGED-->", "<!--/IF_RANGED-->",
						mp, val);
			}
			mp = getLongValue("<!--IF_RANGED-->", "<!--/IF_RANGED-->", val);
		}
		mp = getLongValue("<!--IF_NOT_RANGED-->", "<!--/IF_NOT_RANGED-->", val);
		while (mp != null) {
			if (cls.getRangeValue() != 0) {
				val = swapLongValue("<!--IF_NOT_RANGED-->",
						"<!--/IF_NOT_RANGED-->", "", val);
			} else {
				val = swapLongValue("<!--IF_NOT_RANGED-->",
						"<!--/IF_NOT_RANGED-->", mp, val);
			}
			mp = getLongValue("<!--IF_NOT_RANGED-->", "<!--/IF_NOT_RANGED-->",
					val);
		}
		val = swapValue("<!--SFX-->", cls.getSFX(), val);
		val = swapValue("<!--DISPLAY-->", cls.getDisplay(), val);
		val = swapValue("<!--INPUT-->", cls.getInput(), val);
		val = swapValue("<!--ALIAS-->", cls.getAlias(), val);
		val = swapValue("<!--TEXT-->", text, val);
		if (cls.isIncludeNotesInPrintout()) {
			val = swapValue("<!--NOTES-->", cls.getOutputNotes(), val);
		} else if (cls.getQuantity() > 1) {
			val = swapValue("<!--NOTES-->", "(x" + cls.getQuantity()
					+ " number of items)", val);
		} else {
			val = swapValue("<!--NOTES-->", "", val);
		}
		val = swapValue("<!--OPTION-->", cls.getSelectedOption() == null ? ""
				: cls.getSelectedOption().getDisplay(), val);
		val = swapValue("<!--OPTION_ALIAS-->",
				cls.getSelectedOption() == null ? "" : cls.getSelectedOption()
						.getAlias(), val);
		val = swapValue("<!--OPTION_ID-->",
				cls.getSelectedOption() == null ? "" : cls.getSelectedOption()
						.getXMLID(), val);
		val = swapValue("<!--ACTIVE_COST-->", ""
				+ Rounder.roundUp(cls.getActiveCost()), val);
		val = swapValue("<!--BASE_COST-->", ""
				+ Rounder.roundUp(cls.getTotalCost()), val);
		return val;
	}

	private String getLightningReflexString(String template) {
		String mas = getLongValue("<!--LIGHTNING_REFLEXES-->",
				"<!--/LIGHTNING_REFLEXES-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			int count = 0;
			for (int i = 0; i < hero.getTalents().size(); i += step) {
				GenericObject cls = hero.getTalents().get(i);
				if (!(cls instanceof LightningReflexesSingle)
						&& !(cls instanceof LightningReflexesAll)) {
					continue;
				}
				count++;
				if (count < start) {
					continue;
				}
				if (count > stop) {
					return masValue;
				}
				Talent man = (Talent) cls;
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				val = swapValue("<!--LIGHTNING_REFLEXES_COST-->", man
						.getColumn1Output(), val);
				val = swapValue("<!--LIGHTNING_REFLEXES_TEXT-->", man
						.getNamelessColumn2Output(), val);
				val = swapValue("<!--LIGHTNING_REFLEXES_DISPLAY-->", cls
						.getDisplay(), val);
				val = swapValue("<!--LIGHTNING_REFLEXES_ALIAS-->", cls
						.getAlias(), val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", cls
							.getOutputNotes(), val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", "", val);
				}
				masValue += val;
			}
			if (count < stop) {
				for (int i = 0; i < hero.getPowers().size(); i++) {
					GenericObject cls = hero.getPowers().get(i);
					/*
					 * if (cls instanceof CompoundPower) { CompoundPower cp =
					 * (CompoundPower) cls; for (int j = 0; j <
					 * cp.getPowers().size(); j++) { cls =
					 * cp.getPowers().get(j); if (!(cls instanceof
					 * LightningReflexesSingle) && !(cls instanceof
					 * LightningReflexesAll)) { continue; } count++; if (count <
					 * start) { continue; } if (count > stop) { return masValue;
					 * } Talent man = (Talent) cls; if (masValue.trim().length()
					 * > 0) { masValue += separator; } String val = mas; val =
					 * getGeneralString(val, cls); String text =
					 * cls.getNamelessColumn2Output(); if (cls.getParentList()
					 * != null) { text = text +
					 * cls.getParentList().getColumn2Suffix( cls); } val =
					 * swapValue("<!--LIGHTNING_REFLEXES_COST-->",
					 * man.getColumn1Output(), val); val =
					 * swapValue("<!--LIGHTNING_REFLEXES_TEXT-->", text, val);
					 * val = swapValue( "<!--LIGHTNING_REFLEXES_DISPLAY-->", cls
					 * .getDisplay(), val); val =
					 * swapValue("<!--LIGHTNING_REFLEXES_ALIAS-->",
					 * cls.getAlias(), val); if (cls.isIncludeNotesInPrintout())
					 * { val = swapValue( "<!--LIGHTNING_REFLEXES_NOTES-->", cls
					 * .getOutputNotes(), val); } else if (cls.getQuantity() >
					 * 1) { val = swapValue( "<!--LIGHTNING_REFLEXES_NOTES-->",
					 * "(x" + cls.getQuantity() + " number of items)", val); }
					 * else { val = swapValue(
					 * "<!--LIGHTNING_REFLEXES_NOTES-->", "", val); } masValue
					 * += val; } continue; }
					 */
					if (!(cls instanceof LightningReflexesSingle)
							&& !(cls instanceof LightningReflexesAll)) {
						continue;
					}
					count++;
					if (count < start) {
						continue;
					}
					if (count > stop) {
						return masValue;
					}
					Talent man = (Talent) cls;
					if (masValue.trim().length() > 0) {
						masValue += separator;
					}
					String val = mas;
					val = getGeneralString(val, cls);
					String text = cls.getNamelessColumn2Output();
					if (cls.getParentList() != null) {
						text = text + cls.getParentList().getColumn2Suffix(cls);
					}
					val = swapValue("<!--LIGHTNING_REFLEXES_COST-->", man
							.getColumn1Output(), val);
					val = swapValue("<!--LIGHTNING_REFLEXES_TEXT-->", text, val);
					val = swapValue("<!--LIGHTNING_REFLEXES_DISPLAY-->", cls
							.getDisplay(), val);
					val = swapValue("<!--LIGHTNING_REFLEXES_ALIAS-->", cls
							.getAlias(), val);
					if (cls.isIncludeNotesInPrintout()) {
						val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", cls
								.getOutputNotes(), val);
					} else if (cls.getQuantity() > 1) {
						val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", "(x"
								+ cls.getQuantity() + " number of items)", val);
					} else {
						val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", "",
								val);
					}
					masValue += val;
				}
				for (int i = 0; i < hero.getEquipment().size(); i++) {
					GenericObject cls = hero.getEquipment().get(i);
					/*
					 * if (cls instanceof CompoundPower) { CompoundPower cp =
					 * (CompoundPower) cls; for (int j = 0; j <
					 * cp.getPowers().size(); j++) { cls =
					 * cp.getPowers().get(j); if (!(cls instanceof
					 * LightningReflexesSingle) && !(cls instanceof
					 * LightningReflexesAll)) { continue; } count++; if (count <
					 * start) { continue; } if (count > stop) { return masValue;
					 * } Talent man = (Talent) cls; if (masValue.trim().length()
					 * > 0) { masValue += separator; } String val = mas; val =
					 * getGeneralString(val, cls); String text =
					 * cls.getNamelessColumn2Output(); if (cls.getParentList()
					 * != null) { text = text +
					 * cls.getParentList().getColumn2Suffix( cls); } val =
					 * swapValue("<!--LIGHTNING_REFLEXES_COST-->",
					 * man.getColumn1Output(), val); val =
					 * swapValue("<!--LIGHTNING_REFLEXES_TEXT-->", text, val);
					 * val = swapValue( "<!--LIGHTNING_REFLEXES_DISPLAY-->", cls
					 * .getDisplay(), val); val =
					 * swapValue("<!--LIGHTNING_REFLEXES_ALIAS-->",
					 * cls.getAlias(), val); if (cls.isIncludeNotesInPrintout())
					 * { val = swapValue( "<!--LIGHTNING_REFLEXES_NOTES-->", cls
					 * .getOutputNotes(), val); } else if (cls.getQuantity() >
					 * 1) { val = swapValue( "<!--LIGHTNING_REFLEXES_NOTES-->",
					 * "(x" + cls.getQuantity() + " number of items)", val); }
					 * else { val = swapValue(
					 * "<!--LIGHTNING_REFLEXES_NOTES-->", "", val); } masValue
					 * += val; } continue; }
					 */
					if (!(cls instanceof LightningReflexesSingle)
							&& !(cls instanceof LightningReflexesAll)) {
						continue;
					}
					count++;
					if (count < start) {
						continue;
					}
					if (count > stop) {
						return masValue;
					}
					Talent man = (Talent) cls;
					if (masValue.trim().length() > 0) {
						masValue += separator;
					}
					String val = mas;
					val = getGeneralString(val, cls);
					String text = cls.getNamelessColumn2Output();
					if (cls.getParentList() != null) {
						text = text + cls.getParentList().getColumn2Suffix(cls);
					}
					val = swapValue("<!--LIGHTNING_REFLEXES_COST-->", man
							.getColumn1Output(), val);
					val = swapValue("<!--LIGHTNING_REFLEXES_TEXT-->", text, val);
					val = swapValue("<!--LIGHTNING_REFLEXES_DISPLAY-->", cls
							.getDisplay(), val);
					val = swapValue("<!--LIGHTNING_REFLEXES_ALIAS-->", cls
							.getAlias(), val);
					if (cls.isIncludeNotesInPrintout()) {
						val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", cls
								.getOutputNotes(), val);
					} else if (cls.getQuantity() > 1) {
						val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", "(x"
								+ cls.getQuantity() + " number of items)", val);
					} else {
						val = swapValue("<!--LIGHTNING_REFLEXES_NOTES-->", "",
								val);
					}
					masValue += val;
				}
			}
		}
		return masValue;
	}

	private String getLongValue(String tag, String endTag, String template) {
		String ret = null;
		if ((template.toUpperCase().indexOf(tag.toUpperCase()) >= 0)
				&& (template.toUpperCase().indexOf(endTag.toUpperCase(),
						template.toUpperCase().indexOf(tag.toUpperCase())) > 0)) {
			int index1 = template.toUpperCase().indexOf(tag.toUpperCase())
					+ tag.length();
			int index2 = template.toUpperCase().indexOf(endTag.toUpperCase(),
					index1);
			ret = template.substring(index1, index2);
			return ret;
		} else {
			return null;
		}
	}

	private String getManeuverString(String template) {
		String mas = getLongValue("<!--MANEUVERS-->", "<!--/MANEUVERS-->",
				template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			int count = 0;
			for (int i = 0; i < hero.getManeuvers().size(); i += step) {
				GenericObject cls = hero.getManeuvers().get(i);
				if (!(cls instanceof Maneuver)) {
					continue;
				} else {
					count++;
					if (count < start) {
						continue;
					}
					if (count > stop) {
						return masValue;
					}
				}
				Maneuver man = (Maneuver) cls;
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				val = swapValue("<!--MANEUVER_COST-->", man.getColumn1Output(),
						val);
				val = swapValue("<!--MANEUVER_TEXT-->", man
						.getNamelessColumn2Output(), val);
				val = swapValue("<!--MANEUVER_NAME-->", man.getAlias(), val);
				val = swapValue("<!--MANEUVER_PHASE-->", man.getPhase(), val);
				val = swapValue("<!--MANEUVER_OCV-->", man.getOCV(), val);
				val = swapValue("<!--MANEUVER_DCV-->", man.getDCV(), val);
				if (man.isCustom()) {
					val = swapValue("<!--MANEUVER_EFFECT-->", man
							.getManeuverEffect(), val);
				} else {
					val = swapValue("<!--MANEUVER_EFFECT-->",
							man.useWeapon() ? man.getWeaponEffect() : man
									.getEffect(), val);
				}
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--MANEUVER_NOTES-->", cls
							.getOutputNotes(), val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--MANEUVER_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--MANEUVER_NOTES-->", "", val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	private String getMartialArtsString(String template) {
		String mas = getLongValue("<!--MARTIAL_ARTS-->",
				"<!--/MARTIAL_ARTS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getManeuvers().size())
					&& (i < stop); i += step) {
				GenericObject cls = hero.getManeuvers().get(i);
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String text = cls.getNamelessColumn2Output();
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				String manString = getLongValue("<!--IF_MANEUVER-->",
						"<!--/IF_MANEUVER-->", val);
				String nonString = getLongValue("<!--IF_NON_MANEUVER-->",
						"<!--/IF_NON_MANEUVER-->", val);
				if (cls instanceof Maneuver) {
					val = swapAllLongValues("<!--IF_NON_MANEUVER-->",
							"<!--/IF_NON_MANEUVER-->", "", val);
					Maneuver man = (Maneuver) cls;
					while (manString != null) {
						manString = swapValue("<!--MANEUVER_NAME-->", man
								.getAlias(), manString);
						manString = swapValue("<!--MANEUVER_PHASE-->", man
								.getPhase(), manString);
						manString = swapValue("<!--MANEUVER_OCV-->", man
								.getOCV(), manString);
						manString = swapValue("<!--MANEUVER_DCV-->", man
								.getDCV(), manString);
						if (man.isCustom()) {
							manString = swapValue("<!--MANEUVER_EFFECT-->", man
									.getManeuverEffect(), manString);
						} else {
							manString = swapValue("<!--MANEUVER_EFFECT-->", man
									.useWeapon() ? man.getWeaponEffect() : man
									.getEffect(), manString);
						}
						val = swapLongValue("<!--IF_MANEUVER-->",
								"<!--/IF_MANEUVER-->", manString, val);
						manString = getLongValue("<!--IF_MANEUVER-->",
								"<!--/IF_MANEUVER-->", val);
					}
				} else {
					val = swapAllLongValues("<!--IF_MANEUVER-->",
							"<!--/IF_MANEUVER-->", "", val);
					while (nonString != null) {
						val = swapLongValue("<!--IF_NON_MANEUVER-->",
								"<!--/IF_NON_MANEUVER-->", nonString, val);
						nonString = getLongValue("<!--IF_NON_MANEUVER-->",
								"<!--/IF_NON_MANEUVER-->", val);
					}
				}
				val = swapValue("<!--MA_COST-->", cls.getColumn1Output(), val);
				val = swapValue("<!--MA_TEXT-->", text, val);
				val = swapValue("<!--MA_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--MA_ALIAS-->", cls.getAlias(), val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--MA_NOTES-->", cls.getOutputNotes(),
							val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--MA_NOTES-->", "(x" + cls.getQuantity()
							+ " number of items)", val);
				} else {
					val = swapValue("<!--MA_NOTES-->", "", val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	public String getMathString(String val) {
		String ret = "";
		while ((val.indexOf("(") >= 0)
				&& (val.indexOf(")", val.indexOf("(")) > 0)) {
			int index1 = val.indexOf("(");
			int count = 1;
			int index2 = -1;
			INNER: for (int i = index1 + 1; i < val.length(); i++) {
				if (val.charAt(i) == '(') {
					count++;
				}
				if (val.charAt(i) == ')') {
					if (count > 1) {
						count--;
						continue;
					} else {
						index2 = i;
						break INNER;
					}
				}
			}
			String part1 = val.substring(0, index1);
			String part2 = val.substring(index1 + 1, index2);
			String part3 = val.substring(index2 + 1, val.length());
			val = part1 + getMathString(part2) + part3;
		}
		ret = "" + Rounder.roundHalfUp(HTMLWriter.parseMathString(val));
		return ret;
	}

	private String getModifierString(String template, GenericObject obj) {
		String mas = getLongValue("<!--MODIFIERS-->", "<!--/MODIFIERS-->",
				template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			for (int i = 0; i < obj.getAssignedModifiers().size(); i++) {
				Modifier cls = obj.getAssignedModifiers().get(i);
				String val = mas;
				val = getGeneralString(val, cls);
				val = swapValue("<!--MODIFIER_XMLID-->", cls.getXMLID(), val);
				val = swapValue("<!--MODIFIER_DISPLAY-->", cls.getDisplay(),
						val);
				val = swapValue("<!--MODIFIER_ALIAS-->", cls.getAlias(), val);
				val = swapValue("<!--MODIFIER_TEXT-->", cls
						.getNamelessColumn2Output(), val);
				val = swapValue("<!--MODIFIER_VALUE-->", cls.getFraction(cls
						.getTotalValue()), val);
				masValue += val;
			}
		}
		return masValue;
	}

	/**
	 * Returns the name of this template.
	 * 
	 * @return
	 */
	public String getName() {
		String name = getLongValue("<!--TEMPLATE_NAME-->",
				"<!--/TEMPLATE_NAME-->", raw);
		if ((name == null) || (name.trim().length() == 0)) {
			name = "[unknown]";
		}
		return name;
	}

	private String getNonManeuverString(String template) {
		String mas = getLongValue("<!--NONMANEUVERS-->",
				"<!--/NONMANEUVERS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getManeuvers().size())
					&& (i < stop); i += step) {
				GenericObject cls = hero.getManeuvers().get(i);
				if (cls instanceof Maneuver) {
					continue;
				}
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String text = cls.getNamelessColumn2Output();
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--MA_COST-->", cls.getColumn1Output(), val);
				val = swapValue("<!--MA_TEXT-->", text, val);
				val = swapValue("<!--MA_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--MA_ALIAS-->", cls.getAlias(), val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--MA_NOTES-->", cls.getOutputNotes(),
							val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--MA_NOTES-->", "(x" + cls.getQuantity()
							+ " number of items)", val);
				} else {
					val = swapValue("<!--MA_NOTES-->", "", val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	private String getPerkString(String template) {
		String mas = getLongValue("<!--PERKS-->", "<!--/PERKS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getPerks().size()) && (i < stop); i += step) {
				GenericObject cls = hero.getPerks().get(i);
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String mp = getLongValue("<!--IS_ENHANCER-->",
						"<!--/IS_ENHANCER-->", val);
				while (mp != null) {
					if (cls instanceof Enhancer) {
						val = swapLongValue("<!--IS_ENHANCER-->",
								"<!--/IS_ENHANCER-->", mp, val);
					} else {
						val = swapLongValue("<!--IS_ENHANCER-->",
								"<!--/IS_ENHANCER-->", "", val);
					}
					mp = getLongValue("<!--IS_ENHANCER-->",
							"<!--/IS_ENHANCER-->", val);
				}
				String text = cls.getNamelessColumn2Output();
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--PERK_COST-->", cls.getColumn1Output(), val);
				val = swapValue("<!--PERK_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--PERK_ALIAS-->", cls.getAlias(), val);
				val = swapValue("<!--PERK_TEXT-->", text, val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--PERK_NOTES-->", cls.getOutputNotes(),
							val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--PERK_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--PERK_NOTES-->", "", val);
				}
				if (cls instanceof Perk) {
					val = swapValue("<!--PERK_ROLL-->", ((Perk) cls).getRoll(),
							val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	private String getPowerString(String template) {
		String mas = getLongValue("<!--POWERS-->", "<!--/POWERS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			String compoundSeparator = getLongValue(
					"<!--COMPOUND_POWER_SEPARATOR-->",
					"<!--/COMPOUND_POWER_SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			if (compoundSeparator == null) {
				compoundSeparator = " plus ";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapLongValue("<!--SEPARATOR-->", "<!--/SEPARATOR-->", "",
					mas);
			mas = swapLongValue("<!--COMPOUND_POWER_SEPARATOR-->",
					"<!--/COMPOUND_POWER_SEPARATOR-->", "", mas);
			mas = swapLongValue("<!--START-->", "<!--/START-->", "", mas);
			mas = swapLongValue("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapLongValue("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getPowers().size()) && (i < stop); i += step) {
				GenericObject cls = hero.getPowers().get(i);
				String val = mas;
				if (cls instanceof CompoundPower) {
					CompoundPower cp = (CompoundPower) cls;
					String ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
							"<!--/IF_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						ifcp = getCompoundPowerString(ifcp, cp);
						val = swapLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", ifcp, val);
						ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", val);
					}
					ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
							"<!--/IF_NOT_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						val = swapLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", "", val);
						ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", val);
					}
				} else {
					String ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
							"<!--/IF_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						val = swapLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", "", val);
						ifcp = getLongValue("<!--IF_COMPOUND_POWER-->",
								"<!--/IF_COMPOUND_POWER-->", val);
					}
					ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
							"<!--/IF_NOT_COMPOUND_POWER-->", val);
					while ((ifcp != null) && (ifcp.trim().length() > 0)) {
						val = swapLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", ifcp, val);
						ifcp = getLongValue("<!--IF_NOT_COMPOUND_POWER-->",
								"<!--/IF_NOT_COMPOUND_POWER-->", val);
					}
				}
				String text = cls.getNamelessColumn2Output();
				if (cls instanceof CompoundPower) {
					CompoundPower pow = (CompoundPower) cls;
					String sep = pow.getListSeparator();
					pow.setListSeparator(compoundSeparator);
					text = pow.getNamelessColumn2Output();
					pow.setListSeparator(sep);
				}
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--POWER_TEXT-->", text, val);
				val = swapValue("<!--TEXT-->", text, val);
				val = getGeneralString(val, cls);
				String mp = getLongValue("<!--IS_MP-->", "<!--/IS_MP-->", val);
				while (mp != null) {
					if (cls instanceof Multipower) {
						val = swapLongValue("<!--IS_MP-->", "<!--/IS_MP-->",
								mp, val);
					} else {
						val = swapLongValue("<!--IS_MP-->", "<!--/IS_MP-->",
								"", val);
					}
					mp = getLongValue("<!--IS_MP-->", "<!--/IS_MP-->", val);
				}
				mp = getLongValue("<!--IS_EC-->", "<!--/IS_EC-->", val);
				while (mp != null) {
					if (cls instanceof ElementalControl) {
						val = swapLongValue("<!--IS_EC-->", "<!--/IS_EC-->",
								mp, val);
					} else {
						val = swapLongValue("<!--IS_EC-->", "<!--/IS_EC-->",
								"", val);
					}
					mp = getLongValue("<!--IS_EC-->", "<!--/IS_EC-->", val);
				}
				mp = getLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->", val);
				while (mp != null) {
					if (cls instanceof VariablePowerPool) {
						val = swapLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->",
								mp, val);
					} else {
						val = swapLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->",
								"", val);
					}
					mp = getLongValue("<!--IS_VPP-->", "<!--/IS_VPP-->", val);
				}
				val = swapValue("<!--POWER_COST-->", cls.getColumn1Output(),
						val);
				val = swapValue("<!--POWER_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--POWER_ALIAS-->", cls.getAlias(), val);
				if (cls instanceof Power) {
					val = swapValue("<!--POWER_RANGE-->", ""
							+ cls.getRangeDisplay(), val);
					val = swapValue("<!--POWER_DMG-->", ""
							+ ((Power) cls).getDamageDisplay(), val);
				} else {
					val = swapValue("<!--POWER_RANGE-->", "", val);
					val = swapValue("<!--POWER_DMG-->", "", val);
				}
				val = swapValue("<!--POWER_END-->", cls.getColumn3Output(), val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--POWER_NOTES-->", cls.getOutputNotes(),
							val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--POWER_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--POWER_NOTES-->", "", val);
				}
				if ((masValue.trim().length() > 0) && (val.trim().length() > 0)) {
					masValue += separator;
				}
				if (val.trim().length() > 0) {
					masValue += val;
				}
			}
		}
		return masValue;
	}

	private String getSkillString(String template) {
		String mas = getLongValue("<!--SKILLS-->", "<!--/SKILLS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getSkills().size()) && (i < stop); i += step) {
				GenericObject cls = hero.getSkills().get(i);
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String mp = getLongValue("<!--IS_ENHANCER-->",
						"<!--/IS_ENHANCER-->", val);
				while (mp != null) {
					if (cls instanceof Enhancer) {
						val = swapLongValue("<!--IS_ENHANCER-->",
								"<!--/IS_ENHANCER-->", mp, val);
					} else {
						val = swapLongValue("<!--IS_ENHANCER-->",
								"<!--/IS_ENHANCER-->", "", val);
					}
					mp = getLongValue("<!--IS_ENHANCER-->",
							"<!--/IS_ENHANCER-->", val);
				}
				mp = getLongValue("<!--IS_EVERYMAN-->", "<!--/IS_EVERYMAN-->",
						val);
				while (mp != null) {
					if ((cls instanceof Skill) && ((Skill) cls).isEveryman()) {
						val = swapLongValue("<!--IS_EVERYMAN-->",
								"<!--/IS_EVERYMAN-->", mp, val);
					} else {
						val = swapLongValue("<!--IS_EVERYMAN-->",
								"<!--/IS_EVERYMAN-->", "", val);
					}
					mp = getLongValue("<!--IS_EVERYMAN-->",
							"<!--/IS_EVERYMAN-->", val);
				}
				String text = cls.getNamelessColumn2Output();
				String textnoroll = text;
				if (cls instanceof Skill) {
					textnoroll = ((Skill)cls).getColumn2OutputWithoutRoll();
				}
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--SKILL_COST-->", cls.getColumn1Output(),
						val);
				val = swapValue("<!--SKILL_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--SKILL_ALIAS-->", cls.getAlias(), val);
				val = swapValue("<!--SKILL_TEXT-->", text, val);
				val = swapValue("<!--SKILL_TEXT_NO_ROLL-->", textnoroll, val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--SKILL_NOTES-->", cls.getOutputNotes(),
							val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--SKILL_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--SKILL_NOTES-->", "", val);
				}
				if (cls instanceof Skill) {
					val = swapValue("<!--SKILL_ROLL-->", ((Skill) cls)
							.getRoll(), val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	private String getTalentString(String template) {
		String mas = getLongValue("<!--TALENTS-->", "<!--/TALENTS-->", template);
		String masValue = null;
		if (mas != null) {
			masValue = "";
			String separator = getLongValue("<!--SEPARATOR-->",
					"<!--/SEPARATOR-->", mas);
			if (separator == null) {
				separator = "";
			}
			int start = 1;
			int stop = 999999;
			int step = 1;
			String check = getLongValue("<!--START-->", "<!--/START-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					start = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STOP-->", "<!--/STOP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					stop = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = getLongValue("<!--STEP-->", "<!--/STEP-->", mas);
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					step = Integer.parseInt(check);
					if (step < 1) {
						step = 1;
					}
				} catch (NumberFormatException ex) {
				}
			}
			mas = swapAllLongValues("<!--SEPARATOR-->", "<!--/SEPARATOR-->",
					"", mas);
			mas = swapAllLongValues("<!--START-->", "<!--/START-->", "", mas);
			mas = swapAllLongValues("<!--STOP-->", "<!--/STOP-->", "", mas);
			mas = swapAllLongValues("<!--STEP-->", "<!--/STEP-->", "", mas);
			for (int i = start - 1; (i < hero.getTalents().size())
					&& (i < stop); i += step) {
				GenericObject cls = hero.getTalents().get(i);
				if (masValue.trim().length() > 0) {
					masValue += separator;
				}
				String val = mas;
				val = getGeneralString(val, cls);
				String text = cls.getNamelessColumn2Output();
				if (cls.getParentList() != null) {
					text = text + cls.getParentList().getColumn2Suffix(cls);
				}
				val = swapValue("<!--TALENT_COST-->", cls.getColumn1Output(),
						val);
				val = swapValue("<!--TALENT_DISPLAY-->", cls.getDisplay(), val);
				val = swapValue("<!--TALENT_ALIAS-->", cls.getAlias(), val);
				val = swapValue("<!--TALENT_TEXT-->", text, val);
				if (cls.isIncludeNotesInPrintout()) {
					val = swapValue("<!--TALENT_NOTES-->",
							cls.getOutputNotes(), val);
				} else if (cls.getQuantity() > 1) {
					val = swapValue("<!--TALENT_NOTES-->", "(x"
							+ cls.getQuantity() + " number of items)", val);
				} else {
					val = swapValue("<!--TALENT_NOTES-->", "", val);
				}
				if (cls instanceof Talent) {
					val = swapValue("<!--TALENT_ROLL-->", ((Talent) cls)
							.getRoll(), val);
				}
				masValue += val;
			}
		}
		return masValue;
	}

	private String swapAllLongValues(String tag, String endTag, String value,
			String html) {
		if (value == null) {
			value = "";
		}
		while ((html.toUpperCase().indexOf(tag.toUpperCase()) >= 0)
				&& (html.toUpperCase().indexOf(
						endTag,
						html.toUpperCase().indexOf(tag.toUpperCase())
								+ tag.length()) > 0)) {
			int index1 = html.toUpperCase().indexOf(tag.toUpperCase());
			int index2 = html.toUpperCase().indexOf(endTag.toUpperCase(),
					index1 + tag.length());
			index2 += endTag.length();
			String part1 = "";
			if (index1 >= 0) {
				part1 = html.substring(0, index1);
			}
			String part2 = "";
			if ((index2 <= html.length()) && (index2 > 0)) {
				part2 = html.substring(index2, html.length());
			}
			html = part1 + value + part2;
		}
		return html;
	}

	private String swapLongValue(String tag, String endTag, String value,
			String html) {
		if (value == null) {
			value = "";
		}
		if ((html.toUpperCase().indexOf(tag.toUpperCase()) >= 0)
				&& (html.toUpperCase().indexOf(
						endTag,
						html.toUpperCase().indexOf(tag.toUpperCase())
								+ tag.length()) > 0)) {
			int index1 = html.toUpperCase().indexOf(tag.toUpperCase());
			int index2 = html.toUpperCase().indexOf(endTag.toUpperCase(),
					index1 + tag.length());
			index2 += endTag.length();
			String part1 = "";
			if (index1 >= 0) {
				part1 = html.substring(0, index1);
			}
			String part2 = "";
			if ((index2 <= html.length()) && (index2 > 0)) {
				part2 = html.substring(index2, html.length());
			}
			html = part1 + value + part2;
		}
		return html;
	}

	private String swapMovementString(String template, String xmlID) {
		String ret = template;
		String check = getLongValue("<!--IF_" + xmlID + "-->", "<!--/IF_"
				+ xmlID + "-->", ret);
		if (check == null) {
			return ret;
		}
		int primary = 0;
		int primary2 = 0;
		int secondary = 0;
		int secondary2 = 0;
		int primaryNC = 0;
		int secondaryNC = 0;
		int ncLevels = 0;
		Adder ncm = null;
		for (int i = 0; i < hero.getPowers().size(); i++) {
			GenericObject o = hero.getPowers().get(i);
			if (o.getXMLID().equals(xmlID)) {
				CharAffectingObject move = (CharAffectingObject) o;
				if (move.getAffectTotal()) {
					if (move.findObjectByID(move.getAssignedModifiers(),
							"NONONCOMBAT") != null) {
						if (move.getAffectPrimary()) {
							primary2 += move.getLevels();
						}
						secondary2 += move.getLevels();
					} else {
						if (move.findObjectByID(move.getAssignedAdders(),
								"IMPROVEDNONCOMBAT") != null) {
							ncm = (Adder) move.findObjectByID(move
									.getAssignedAdders(), "IMPROVEDNONCOMBAT");
							ncLevels += ncm.getLevels();
						}
						if (move.getAffectPrimary()) {
							primary += move.getLevels();
						}
						secondary += move.getLevels();
					}
				}
			} else if (o instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) o;
				for (int j = 0; j < cp.getPowers().size(); j++) {
					GenericObject o2 = cp.getPowers().get(j);
					if (o2.getXMLID().equals(xmlID)) {
						CharAffectingObject move = (CharAffectingObject) o2;
						if (move.getAffectTotal()) {
							if (move.findObjectByID(
									move.getAssignedModifiers(), "NONONCOMBAT") != null) {
								if (move.getAffectPrimary()) {
									primary2 += move.getLevels();
								}
								secondary2 += move.getLevels();
							} else {
								if (move.findObjectByID(move
										.getAssignedAdders(),
										"IMPROVEDNONCOMBAT") != null) {
									ncm = (Adder) move.findObjectByID(move
											.getAssignedAdders(),
											"IMPROVEDNONCOMBAT");
									ncLevels += ncm.getLevels();
								}
								if (move.getAffectPrimary()) {
									primary += move.getLevels();
								}
								secondary += move.getLevels();
							}
						}
					}
				}
			}
		}
		for (int i = 0; i < hero.getEquipment().size(); i++) {
			GenericObject o = hero.getEquipment().get(i);
			if (o.getXMLID().equals(xmlID)) {
				CharAffectingObject move = (CharAffectingObject) o;
				if (move.getAffectTotal()) {
					if (move.findObjectByID(move.getAssignedModifiers(),
							"NONONCOMBAT") != null) {
						if (move.getAffectPrimary()) {
							primary2 += move.getLevels();
						}
						secondary2 += move.getLevels();
					} else {
						if (move.findObjectByID(move.getAssignedAdders(),
								"IMPROVEDNONCOMBAT") != null) {
							ncm = (Adder) move.findObjectByID(move
									.getAssignedAdders(), "IMPROVEDNONCOMBAT");
							ncLevels += ncm.getLevels();
						}
						if (move.getAffectPrimary()) {
							primary += move.getLevels();
						}
						secondary += move.getLevels();
					}
				}
			} else if (o instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) o;
				for (int j = 0; j < cp.getPowers().size(); j++) {
					GenericObject o2 = cp.getPowers().get(j);
					if (o2.getXMLID().equals(xmlID)) {
						CharAffectingObject move = (CharAffectingObject) o2;
						if (move.getAffectTotal()) {
							if (move.findObjectByID(
									move.getAssignedModifiers(), "NONONCOMBAT") != null) {
								if (move.getAffectPrimary()) {
									primary2 += move.getLevels();
								}
								secondary2 += move.getLevels();
							} else {
								if (move.findObjectByID(move
										.getAssignedAdders(),
										"IMPROVEDNONCOMBAT") != null) {
									ncm = (Adder) move.findObjectByID(move
											.getAssignedAdders(),
											"IMPROVEDNONCOMBAT");
									ncLevels += ncm.getLevels();
								}
								if (move.getAffectPrimary()) {
									primary += move.getLevels();
								}
								secondary += move.getLevels();
							}
						}
					}
				}
			}
		}
		for (int i = 0; i < hero.getCharacteristics().size(); i++) {
			GenericObject o = hero.getCharacteristics().get(i);
			if (o.getXMLID().equals(xmlID)) {
				Characteristic move = (Characteristic) o;
				if (move.findObjectByID(move.getAssignedModifiers(),
						"NONONCOMBAT") != null) {
					primary2 += move.getCharacteristicValue();
					secondary2 += move.getCharacteristicValue();
				} else {
					if (move.findObjectByID(move.getAssignedAdders(),
							"IMPROVEDNONCOMBAT") != null) {
						ncm = (Adder) move.findObjectByID(move
								.getAssignedAdders(), "IMPROVEDNONCOMBAT");
						ncLevels += ncm.getLevels();
					}
					primary += move.getCharacteristicValue();
					secondary += move.getCharacteristicValue();
				}
			}
		}
		int ncMult = 2;
		if (ncLevels > 0) {
			ncMult = ncLevels * ncm.getLevelMultiplier();
		}
		if ((ncLevels > 0) && (ncm.getLevelPower() != 1)) {
			ncMult = (int) (ncm.getLevelMultiplier() * Math.pow(ncm
					.getLevelPower(), ncLevels));
		}
		primaryNC = primary * ncMult;
		secondaryNC = secondary * ncMult;
		primaryNC += primary2;
		secondaryNC += secondary2;
		primary += primary2;
		secondary += secondary2;
		if ((primary == 0) && (secondary == 0) && (primaryNC == 0)
				&& (secondaryNC == 0)) {
			ret = swapAllLongValues("<!--IF_" + xmlID + "-->", "<!--/IF_"
					+ xmlID + "-->", "", ret);
		} else {
			String total = primary + (is6E ? "m" : "\"");
			if (primary != secondary) {
				total += "/" + secondary + (is6E ? "m" : "\"");
			}
			String totalNC = primaryNC + (is6E ? "m" : "\"");
			if (primaryNC != secondaryNC) {
				totalNC += "/" + secondaryNC + (is6E ? "m" : "\"");
			}
			while (check != null) {
				check = swapValue("<!--" + xmlID + "_PRIMARY-->", primary
						+ (is6E ? "m" : "\""), check);
				check = swapValue("<!--" + xmlID + "_SECONDARY-->", ""
						+ secondary + (is6E ? "m" : "\""), check);
				check = swapValue("<!--" + xmlID + "_PRIMARY_NUMBER-->",
						primary + "", check);
				check = swapValue("<!--" + xmlID + "_SECONDARY_NUMBER-->", ""
						+ secondary + "", check);
				check = swapValue("<!--" + xmlID + "_TOTAL-->", total, check);
				check = swapValue("<!--" + xmlID + "_PRIMARY_NONCOMBAT-->",
						primaryNC + (is6E ? "m" : "\""), check);
				check = swapValue("<!--" + xmlID + "_SECONDARY_NONCOMBAT-->",
						"" + secondaryNC + (is6E ? "m" : "\""), check);
				check = swapValue("<!--" + xmlID
						+ "_PRIMARY_NONCOMBAT_NUMBER-->", primaryNC + "", check);
				check = swapValue("<!--" + xmlID
						+ "_SECONDARY_NONCOMBAT_NUMBER-->", "" + secondaryNC
						+ "", check);
				check = swapValue("<!--" + xmlID + "_TOTAL_NONCOMBAT-->",
						totalNC, check);
				ret = swapLongValue("<!--IF_" + xmlID + "-->", "<!--/IF_"
						+ xmlID + "-->", check, ret);
				check = getLongValue("<!--IF_" + xmlID + "-->", "<!--/IF_"
						+ xmlID + "-->", ret);
			}
		}
		return ret;
	}

	private String swapValue(String tag, String value, String html) {
		if (value == null) {
			value = "";
		}
		if ((tag == null) || (html == null)) {
			return html;
		}
		while (html.toUpperCase().indexOf(tag.toUpperCase()) >= 0) {
			int index = html.toUpperCase().indexOf(tag.toUpperCase());
			String part1 = "";
			if (index >= 0) {
				part1 = html.substring(0, index);
			}
			String part2 = "";
			if (index + tag.length() <= html.length()) {
				part2 = html.substring(index + tag.length(), html.length());
			}
			html = part1 + value + part2;
		}
		return html;
	}
}